/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.transfer.internal;

import com.sinacloud.scs.SCSClientException;
import com.sinacloud.scs.event.ProgressEvent;
import com.sinacloud.scs.event.ProgressListenerCallbackExecutor;
import com.sinacloud.scs.services.scs.SCS;
import com.sinacloud.scs.services.scs.model.CompleteMultipartUploadRequest;
import com.sinacloud.scs.services.scs.model.PartETag;
import com.sinacloud.scs.services.scs.model.PutObjectRequest;
import com.sinacloud.scs.services.scs.transfer.Transfer;
import com.sinacloud.scs.services.scs.transfer.TransferManager;
import com.sinacloud.scs.services.scs.transfer.TransferManagerConfiguration;
import com.sinacloud.scs.services.scs.transfer.internal.ProgressListenerChain;
import com.sinacloud.scs.services.scs.transfer.internal.TransferMonitor;
import com.sinacloud.scs.services.scs.transfer.internal.UploadCallable;
import com.sinacloud.scs.services.scs.transfer.internal.UploadImpl;
import com.sinacloud.scs.services.scs.transfer.model.UploadResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadMonitor
implements Callable<UploadResult>,
TransferMonitor {
    private final SCS s3;
    private final ExecutorService threadPool;
    private final PutObjectRequest putObjectRequest;
    private ScheduledExecutorService timedThreadPool;
    private static final Log log = LogFactory.getLog(UploadMonitor.class);
    private final TransferManagerConfiguration configuration;
    private final ProgressListenerCallbackExecutor progressListenerChainCallbackExecutor;
    private final UploadCallable multipartUploadCallable;
    private final UploadImpl transfer;
    private String uploadId;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private boolean isUploadDone = false;
    private Future<UploadResult> nextFuture;
    private int pollInterval = 5000;

    public synchronized Future<UploadResult> getFuture() {
        return this.nextFuture;
    }

    private synchronized void setNextFuture(Future<UploadResult> nextFuture) {
        this.nextFuture = nextFuture;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isUploadDone;
    }

    private synchronized void markAllDone() {
        this.isUploadDone = true;
    }

    public UploadMonitor(TransferManager manager, UploadImpl transfer, ExecutorService threadPool, UploadCallable multipartUploadCallable, PutObjectRequest putObjectRequest, com.sinacloud.scs.event.ProgressListenerChain progressListenerChain) {
        this.s3 = manager.getAmazonS3Client();
        this.configuration = manager.getConfiguration();
        this.multipartUploadCallable = multipartUploadCallable;
        this.threadPool = threadPool;
        this.putObjectRequest = putObjectRequest;
        this.progressListenerChainCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener(progressListenerChain);
        this.transfer = transfer;
        this.setNextFuture(threadPool.submit(this));
    }

    @Deprecated
    public UploadMonitor(TransferManager manager, UploadImpl transfer, ExecutorService threadPool, UploadCallable multipartUploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        this(manager, transfer, threadPool, multipartUploadCallable, putObjectRequest, progressListenerChain.transformToGeneralProgressListenerChain());
    }

    public void setTimedThreadPool(ScheduledExecutorService timedThreadPool) {
        this.timedThreadPool = timedThreadPool;
    }

    @Override
    public UploadResult call() throws Exception {
        try {
            if (this.uploadId == null) {
                return this.upload();
            }
            return this.poll();
        }
        catch (CancellationException e) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            this.fireProgressEvent(16);
            throw new SCSClientException("Upload canceled");
        }
        catch (Exception e) {
            this.transfer.setState(Transfer.TransferState.Failed);
            this.fireProgressEvent(8);
            throw e;
        }
    }

    private UploadResult poll() throws InterruptedException {
        for (Future<PartETag> f : this.futures) {
            if (f.isDone()) continue;
            this.reschedule();
            return null;
        }
        for (Future<PartETag> f : this.futures) {
            if (!f.isCancelled()) continue;
            throw new CancellationException();
        }
        return this.completeMultipartUpload();
    }

    private UploadResult upload() throws Exception, InterruptedException {
        UploadResult result = this.multipartUploadCallable.call();
        if (result != null) {
            this.uploadComplete();
        } else {
            this.uploadId = this.multipartUploadCallable.getMultipartUploadId();
            this.futures.addAll(this.multipartUploadCallable.getFutures());
            this.reschedule();
        }
        return result;
    }

    private void uploadComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartUploadCallable.isMultipartUpload()) {
            this.fireProgressEvent(4);
        }
    }

    private void reschedule() {
        this.setNextFuture(this.timedThreadPool.schedule(new Callable<UploadResult>(){

            @Override
            public UploadResult call() throws Exception {
                UploadMonitor.this.setNextFuture(UploadMonitor.this.threadPool.submit(UploadMonitor.this));
                return null;
            }
        }, (long)this.pollInterval, TimeUnit.MILLISECONDS));
    }

    private void fireProgressEvent(int eventType) {
        if (this.progressListenerChainCallbackExecutor == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0L);
        event.setEventCode(eventType);
        this.progressListenerChainCallbackExecutor.progressChanged(event);
    }

    private UploadResult completeMultipartUpload() {
        this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.putObjectRequest.getBucketName(), this.putObjectRequest.getKey(), this.uploadId, this.collectPartETags()));
        this.uploadComplete();
        UploadResult uploadResult = new UploadResult();
        return uploadResult;
    }

    private List<PartETag> collectPartETags() {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>(this.futures.size());
        for (Future<PartETag> future : this.futures) {
            try {
                partETags.add(future.get());
            }
            catch (Exception e) {
                throw new SCSClientException("Unable to upload part: " + e.getCause().getMessage(), e.getCause());
            }
        }
        return partETags;
    }
}

