/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.solidfire.jsvcgen.JsonRpcException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Scanner;

public class JsonRpcServiceBase {
    private final URL endpoint;
    private final GsonBuilder gsonBuilder = new GsonBuilder();

    protected JsonRpcServiceBase(URL uRL) {
        this.endpoint = uRL;
    }

    public URL getEndpoint() {
        return this.endpoint;
    }

    protected final GsonBuilder getGsonBuilder() {
        return this.gsonBuilder;
    }

    protected static void prepareConnection(HttpURLConnection httpURLConnection) {
        try {
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
        }
        catch (ProtocolException protocolException) {
            throw new RuntimeException("Your HTTP connection does not support \"POST\"", protocolException);
        }
        httpURLConnection.addRequestProperty("Accept", "application/json");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <TResult, TRequest> TResult sendRequest(String string, TRequest TRequest, Class<? extends TRequest> clazz, Class<? extends TResult> clazz2) {
        if (null == string) throw new IllegalArgumentException("method is null or empty");
        if (string.trim().isEmpty()) {
            throw new IllegalArgumentException("method is null or empty");
        }
        if (null == TRequest) {
            throw new IllegalArgumentException("request params is null");
        }
        if (null == clazz) {
            throw new IllegalArgumentException("request params class is null");
        }
        if (null == clazz2) {
            throw new IllegalArgumentException("result params class is null");
        }
        try {
            byte[] byArray = this.encodeRequest(string, TRequest, clazz);
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.endpoint.openConnection();
            JsonRpcServiceBase.prepareConnection(httpURLConnection);
            try (Closeable closeable = httpURLConnection.getOutputStream();){
                ((OutputStream)closeable).write(byArray);
                ((OutputStream)closeable).flush();
            }
            closeable = JsonRpcServiceBase.getConnectionStream(httpURLConnection);
            var8_9 = null;
            try {
                Object object;
                Object object2 = object = this.gsonBuilder.create().fromJson((Reader)new InputStreamReader((InputStream)closeable), clazz2);
                return (TResult)object2;
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (var8_9 != null) {
                        try {
                            ((InputStream)closeable).close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)closeable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw JsonRpcServiceBase.getExceptionForIOException(iOException);
        }
    }

    protected <TRequest> byte[] encodeRequest(String string, TRequest TRequest, Class<? extends TRequest> clazz) {
        if (null == string || string.trim().isEmpty()) {
            throw new IllegalArgumentException("method is null or empty");
        }
        if (null == TRequest) {
            throw new IllegalArgumentException("request params is null");
        }
        if (null == clazz) {
            throw new IllegalArgumentException("request params class is null");
        }
        Gson gson = this.gsonBuilder.create();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", (Number)1);
        jsonObject.addProperty("method", string);
        jsonObject.addProperty("json-rpc", "2.0");
        jsonObject.add("params", gson.toJsonTree(TRequest, clazz));
        return gson.toJson((JsonElement)jsonObject).getBytes();
    }

    protected <TResponse> TResponse decodeResponse(InputStream inputStream, Class<? extends TResponse> clazz) {
        if (null == inputStream) {
            throw new IllegalArgumentException("request params is null");
        }
        if (null == clazz) {
            throw new IllegalArgumentException("result params class is null");
        }
        JsonObject jsonObject = new JsonParser().parse((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
        if (jsonObject.has("error")) {
            throw JsonRpcServiceBase.extractErrorResponse(jsonObject);
        }
        return (TResponse)this.gsonBuilder.create().fromJson(jsonObject.get("result"), clazz);
    }

    protected static InputStream getConnectionStream(HttpURLConnection httpURLConnection) throws IOException {
        return httpURLConnection.getResponseCode() == 200 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
    }

    protected static RuntimeException extractErrorResponse(JsonObject jsonObject) {
        String string = jsonObject.get("error").getAsJsonObject().get("message").getAsString();
        return new JsonRpcException(string);
    }

    protected static RuntimeException getExceptionForIOException(IOException iOException) {
        if (null == iOException) {
            return new JsonRpcException();
        }
        return new JsonRpcException(iOException);
    }

    protected static String convertStreamToString(InputStream inputStream) {
        try (Scanner scanner = new Scanner(inputStream);){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }
}

