/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.solidfire.jsvcgen.client.ApiException;
import com.solidfire.jsvcgen.client.ApiServerException;
import com.solidfire.jsvcgen.client.RequestDispatcher;
import com.solidfire.jsvcgen.client.VersioningUtils;
import com.solidfire.jsvcgen.serialization.GsonUtil;
import com.solidfire.jsvcgen.serialization.OptionalAdaptorUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBase {
    private static final Logger log = LoggerFactory.getLogger(ServiceBase.class);
    private static final AtomicLong sessionId;
    private final RequestDispatcher requestDispatcher;
    private final GsonBuilder gsonBuilder = GsonUtil.getDefaultBuilder();

    protected ServiceBase(RequestDispatcher requestDispatcher) {
        this.requestDispatcher = requestDispatcher;
    }

    public final RequestDispatcher getRequestDispatcher() {
        return this.requestDispatcher;
    }

    protected final GsonBuilder getGsonBuilder() {
        return this.gsonBuilder;
    }

    protected <TResult, TRequest> TResult sendRequest(String string, TRequest TRequest, Class<TRequest> clazz, Class<TResult> clazz2) {
        Object object;
        if (null == string || string.trim().isEmpty()) {
            throw new IllegalArgumentException("method is null or empty");
        }
        if (null == TRequest) {
            throw new IllegalArgumentException("request params is null");
        }
        if (null == clazz) {
            throw new IllegalArgumentException("request params class is null");
        }
        if (null == clazz2) {
            throw new IllegalArgumentException("result params class is null");
        }
        Map<String, Constructor<TRequest>> map = VersioningUtils.mapConstructorVersions(TRequest);
        if (map.size() > 1 && !(object = VersioningUtils.getValuesOfMethodsWithGreaterVersion(TRequest, this.requestDispatcher.getVersion())).isEmpty()) {
            throw new ApiException("The following parameters(s) are not applicable to this version of the API. " + VersioningUtils.methodParametersToString(object.keySet()));
        }
        object = this.encodeRequest(string, TRequest, clazz);
        log.debug("Request: {}", object);
        try {
            String string2 = this.getRequestDispatcher().dispatchRequest((String)object);
            return this.decodeResponse(string2, clazz2);
        }
        catch (IOException iOException) {
            throw new ApiException(iOException);
        }
    }

    protected <TRequest> String encodeRequest(String string, TRequest TRequest, Class<TRequest> clazz) {
        if (null == string || string.trim().isEmpty()) {
            throw new IllegalArgumentException("method is null or empty");
        }
        if (null == TRequest) {
            throw new IllegalArgumentException("request params is null");
        }
        if (null == clazz) {
            throw new IllegalArgumentException("request params class is null");
        }
        Gson gson = this.getGsonBuilder().create();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", (Number)sessionId.incrementAndGet());
        jsonObject.addProperty("method", string);
        jsonObject.addProperty("json-rpc", "2.0");
        jsonObject.add("params", gson.toJsonTree(TRequest, clazz));
        return gson.toJson((JsonElement)jsonObject);
    }

    protected <TResult> TResult decodeResponse(String string, Class<TResult> clazz) {
        log.debug("Response: {}", (Object)string);
        Gson gson = this.getGsonBuilder().create();
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(string));
            jsonReader.setLenient(true);
            JsonObject jsonObject = (JsonObject)gson.fromJson(jsonReader, JsonObject.class);
            if (jsonObject.has("error")) {
                throw this.extractApiError(jsonObject.get("error"));
            }
            Object object = gson.fromJson(jsonObject.get("result"), clazz);
            OptionalAdaptorUtils.initializeAllNullOptionalFieldsAsEmpty(object);
            return (TResult)object;
        }
        catch (ClassCastException classCastException) {
            Pattern pattern = Pattern.compile("<p> (.*?)</p>");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                throw new ApiServerException("Not Found", "404", matcher.group(1));
            }
            throw new ApiException(String.format("There was a problem parsing the response from the server. ( response=%s )", string), classCastException);
        }
        catch (JsonParseException | NullPointerException throwable) {
            log.debug(string);
            throw new ApiException(String.format("There was a problem parsing the response from the server. ( response=%s )", string), throwable);
        }
    }

    protected ApiServerException extractApiError(JsonElement jsonElement) {
        return (ApiServerException)this.getGsonBuilder().create().fromJson(jsonElement, ApiServerException.class);
    }

    static {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        });
        sessionId = new AtomicLong(0L);
    }
}

