/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.serialization;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.solidfire.jsvcgen.javautil.Optional;
import com.solidfire.jsvcgen.serialization.OptionalAdaptorUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class OptionalAdapter
implements JsonSerializer<Optional<?>>,
JsonDeserializer<Optional<?>>,
InstanceCreator<Optional<?>> {
    public static Class serializingClass() {
        return Optional.class;
    }

    public Optional<?> createInstance(Type type) {
        return Optional.empty();
    }

    public JsonElement serialize(Optional<?> optional, Type type, JsonSerializationContext jsonSerializationContext) {
        if (!optional.isPresent()) {
            return null;
        }
        return jsonSerializationContext.serialize(optional.get());
    }

    public Optional<?> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        if (!(jsonElement.isJsonObject() || jsonElement.isJsonArray() || !jsonElement.isJsonNull() && jsonElement.getAsString() != null)) {
            return Optional.empty();
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type type2 = parameterizedType.getActualTypeArguments()[0];
        if (type2.equals(String.class)) {
            return Optional.of(jsonElement.getAsString());
        }
        if (!jsonElement.isJsonObject() && !jsonElement.isJsonArray() && jsonElement.getAsString().trim().length() == 0) {
            return Optional.empty();
        }
        if ((jsonElement.isJsonObject() || jsonElement.isJsonArray()) && jsonElement.isJsonNull()) {
            return Optional.empty();
        }
        if (type2.equals(Integer.class)) {
            return Optional.of(jsonElement.getAsInt());
        }
        if (type2.equals(Long.class)) {
            return Optional.of(jsonElement.getAsLong());
        }
        if (type2.equals(Double.class)) {
            return Optional.of(jsonElement.getAsDouble());
        }
        Object object = jsonDeserializationContext.deserialize(jsonElement, type2);
        OptionalAdaptorUtils.initializeAllNullOptionalFieldsAsEmpty(object);
        return Optional.of(object);
    }
}

