/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.client;

import com.solidfire.jsvcgen.annotation.Since;
import com.solidfire.jsvcgen.client.ApiException;
import com.solidfire.jsvcgen.javautil.Optional;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VersioningUtils {
    public static String getVersionFromEndpoint(URL uRL) {
        for (String string : uRL.toString().split("/")) {
            if (!VersioningUtils.isVersionString(string)) continue;
            return string;
        }
        throw new ApiException("Version missing in endpoint url");
    }

    public static boolean isVersionString(String string) {
        return null != string && !string.trim().isEmpty() && string.matches("^\\d{1,3}.\\d{1,2}$");
    }

    public static boolean isVersionGreater(String string, String string2) {
        return string.compareTo(string2) < 0;
    }

    public static boolean isVersionGreaterOrEqual(String string, String string2) {
        return string.compareTo(string2) <= 0;
    }

    public static boolean isVersionLess(String string, String string2) {
        return string.compareTo(string2) > 0;
    }

    public static boolean isVersionLessOrEqual(String string, String string2) {
        return string.compareTo(string2) >= 0;
    }

    public static <T> Map<String, Constructor<T>> mapConstructorVersions(T t) {
        HashMap<String, Constructor<T>> hashMap = new HashMap<String, Constructor<T>>(t.getClass().getConstructors().length);
        for (Constructor<?> constructor : t.getClass().getConstructors()) {
            Since since = constructor.getAnnotation(Since.class);
            Since since2 = since;
            if (null == since2) continue;
            hashMap.put(since2.value(), constructor);
        }
        return hashMap;
    }

    public static <T> Map<String, Constructor<T>> mapConstructorVersionsLargerThan(T t, String string) {
        Map<String, Constructor<T>> map = VersioningUtils.mapConstructorVersions(t);
        HashMap<String, Constructor<T>> hashMap = new HashMap<String, Constructor<T>>(map.size());
        for (Map.Entry<String, Constructor<T>> entry : map.entrySet()) {
            if (!VersioningUtils.isVersionGreater(string, entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public static <T> List<Method> getMethodsOfGreaterVersion(T t, String string) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : t.getClass().getDeclaredMethods()) {
            Since since = method.getAnnotation(Since.class);
            Since since2 = since;
            if (null == since2 || !VersioningUtils.isVersionGreater(string, since2.value())) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    public static <T> Map<Method, Object> getValuesOfMethodsWithGreaterVersion(T t, String string) {
        LinkedHashMap<Method, Object> linkedHashMap = new LinkedHashMap<Method, Object>();
        for (Method method : VersioningUtils.getMethodsOfGreaterVersion(t, string)) {
            try {
                Object object = method.invoke(t, new Object[0]);
                if (object == null || Optional.empty().equals(object)) continue;
                linkedHashMap.put(method, object);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
        return linkedHashMap;
    }

    public static List<String> transformMethodsToParameterNames(List<Method> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Method method : list) {
            String string = method.getName().replace("get", "");
            arrayList.add(string.substring(0, 1).toLowerCase() + string.substring(1));
        }
        return arrayList;
    }

    public static String methodParametersToString(Collection<Method> collection) {
        return Arrays.toString(VersioningUtils.transformMethodsToParameterNames(new ArrayList<Method>(collection)).toArray());
    }
}

