/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.reflection;

import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static <T> T safeGet(Field field, Object object) {
        try {
            boolean bl = field.isAccessible();
            field.setAccessible(true);
            Object object2 = field.get(object);
            field.setAccessible(bl);
            return (T)object2;
        }
        catch (IllegalAccessException illegalAccessException) {
            log.debug("Error getting field {} value from {}", (Object)field, (Object)object.getClass().getSimpleName());
            return null;
        }
    }

    public static <T> void safeSet(Field field, Object object, T t) {
        try {
            boolean bl = field.isAccessible();
            field.setAccessible(true);
            field.set(object, t);
            field.setAccessible(bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.debug("Error setting field {} in {} with value {}", new Object[]{field, object.getClass().getSimpleName(), t});
        }
    }
}

