/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.serialization;

import com.solidfire.jsvcgen.javautil.Optional;
import com.solidfire.jsvcgen.reflection.ReflectionUtils;
import com.solidfire.jsvcgen.serialization.OptionalAdaptorUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayAdaptorUtils {
    private static final Logger log = LoggerFactory.getLogger(OptionalAdaptorUtils.class);

    public static <T> T convertAllArrayListsToArrays(T t) {
        if (!ArrayAdaptorUtils.hasMapFields(t)) {
            return t;
        }
        ArrayAdaptorUtils.convert(ArrayAdaptorUtils.getConvertibleMaps(t));
        return t;
    }

    private static void convert(Map<Map<String, Object>, Map<String, List>> map) {
        for (Map.Entry<Map<String, Object>, Map<String, List>> entry : map.entrySet()) {
            for (Map.Entry<String, List> entry2 : entry.getValue().entrySet()) {
                entry.getKey().put(entry2.getKey(), entry2.getValue().toArray());
            }
        }
    }

    private static <T> Map<Map<String, Object>, Map<String, List>> getConvertibleMaps(T t) {
        HashMap<Map<String, Object>, Map<String, List>> hashMap = new HashMap<Map<String, Object>, Map<String, List>>();
        for (Map<String, Object> map : ArrayAdaptorUtils.getAllMaps(t)) {
            hashMap.put(map, new HashMap());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (!(entry.getValue() instanceof List)) continue;
                ((Map)hashMap.get(map)).put(entry.getKey(), (List)entry.getValue());
            }
        }
        return hashMap;
    }

    public static boolean hasMapFields(Object object) {
        if (object == null || object instanceof String) {
            return false;
        }
        if (object.getClass().isArray() && object.getClass().getComponentType().isPrimitive()) {
            return false;
        }
        if (object instanceof Optional) {
            return ((Optional)object).isPresent() && ArrayAdaptorUtils.hasMapFields(((Optional)object).get());
        }
        if (object.getClass().isArray() && !object.getClass().isPrimitive()) {
            for (Object object2 : (Object[])object) {
                if (!ArrayAdaptorUtils.hasMapFields(object2)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                if (!ArrayAdaptorUtils.hasMapFields(t)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Map) {
            return true;
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.getType().getName().startsWith("java") && !field.getType().getName().startsWith("java.util") || !ArrayAdaptorUtils.hasMapFields(ReflectionUtils.safeGet(field, object))) continue;
            return true;
        }
        return false;
    }

    public static List<Map<String, Object>> getAllMaps(Object object) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        if (object == null || object instanceof String) {
            return arrayList;
        }
        if (object.getClass().isArray() && !object.getClass().isPrimitive()) {
            for (Object object2 : (Object[])object) {
                if (!ArrayAdaptorUtils.hasMapFields(object2)) continue;
                arrayList.addAll(ArrayAdaptorUtils.getAllMaps(object2));
            }
            return arrayList;
        }
        if (object instanceof Map) {
            arrayList.add((Map)object);
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (ArrayAdaptorUtils.hasMapFields(entry.getKey())) {
                    arrayList.addAll(ArrayAdaptorUtils.getAllMaps(entry.getKey()));
                }
                arrayList.addAll(ArrayAdaptorUtils.getAllMaps(entry.getValue()));
            }
            return arrayList;
        }
        if (object instanceof Optional && ((Optional)object).isPresent()) {
            arrayList.addAll(ArrayAdaptorUtils.getAllMaps(((Optional)object).get()));
            return arrayList;
        }
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                if (!ArrayAdaptorUtils.hasMapFields(t)) continue;
                arrayList.addAll(ArrayAdaptorUtils.getAllMaps(t));
            }
            return arrayList;
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.getType().getName().startsWith("java") && !field.getType().getName().startsWith("java.util") || !(ReflectionUtils.safeGet(field, object) instanceof Map)) continue;
            Map map = (Map)ReflectionUtils.safeGet(field, object);
            arrayList.add(map);
        }
        return arrayList;
    }
}

