/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.serialization;

import com.solidfire.jsvcgen.javautil.Optional;
import com.solidfire.jsvcgen.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalAdaptorUtils {
    private static final Logger log = LoggerFactory.getLogger(OptionalAdaptorUtils.class);

    public static <T> T initializeAllNullOptionalFieldsAsEmpty(T t) {
        if (!OptionalAdaptorUtils.hasOptionalFields(t)) {
            return t;
        }
        for (Map.Entry<Object, List<Field>> entry : OptionalAdaptorUtils.getOptionalFields(t).entrySet()) {
            Object object = entry.getKey();
            List<Field> list = entry.getValue();
            for (Field field : list) {
                if (ReflectionUtils.safeGet(field, object) != null) continue;
                ReflectionUtils.safeSet(field, object, Optional.empty());
            }
        }
        return t;
    }

    public static boolean hasOptionalFields(Object object) {
        if (object == null || object instanceof String) {
            return false;
        }
        if (object.getClass().isArray() && object.getClass().getComponentType().isPrimitive()) {
            return false;
        }
        if (object.getClass().isArray() && !object.getClass().isPrimitive()) {
            for (Object object2 : (Object[])object) {
                if (!OptionalAdaptorUtils.hasOptionalFields(object2)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                if (!OptionalAdaptorUtils.hasOptionalFields(t)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (!OptionalAdaptorUtils.hasOptionalFields(entry.getKey()) && !OptionalAdaptorUtils.hasOptionalFields(entry.getValue())) continue;
                return true;
            }
            return false;
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.getType().getName().startsWith("java.")) continue;
            if (field.getType() == Optional.class) {
                return true;
            }
            if (!OptionalAdaptorUtils.hasOptionalFields(ReflectionUtils.safeGet(field, object))) continue;
            return true;
        }
        return false;
    }

    public static Map<Object, List<Field>> getOptionalFields(Object object) {
        HashMap<Object, List<Field>> hashMap = new HashMap<Object, List<Field>>();
        if (object == null || object instanceof String) {
            return hashMap;
        }
        if (object.getClass().isArray() && !object.getClass().isPrimitive()) {
            for (Object object2 : (Object[])object) {
                if (!OptionalAdaptorUtils.hasOptionalFields(object2)) continue;
                hashMap.putAll(OptionalAdaptorUtils.getOptionalFields(object2));
            }
            return hashMap;
        }
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                if (!OptionalAdaptorUtils.hasOptionalFields(t)) continue;
                hashMap.putAll(OptionalAdaptorUtils.getOptionalFields(t));
            }
            return hashMap;
        }
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (OptionalAdaptorUtils.hasOptionalFields(entry.getKey())) {
                    hashMap.putAll(OptionalAdaptorUtils.getOptionalFields(entry.getKey()));
                }
                if (!OptionalAdaptorUtils.hasOptionalFields(entry.getValue())) continue;
                hashMap.putAll(OptionalAdaptorUtils.getOptionalFields(entry.getValue()));
            }
            return hashMap;
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.getType().getName().startsWith("java.")) continue;
            if (field.getType() == Optional.class) {
                if (!hashMap.containsKey(object)) {
                    hashMap.put(object, new ArrayList());
                }
                ((List)hashMap.get(object)).add(field);
                continue;
            }
            Object t = ReflectionUtils.safeGet(field, object);
            if (!OptionalAdaptorUtils.hasOptionalFields(t)) continue;
            hashMap.putAll(OptionalAdaptorUtils.getOptionalFields(t));
        }
        return hashMap;
    }
}

