/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.client;

import com.solidfire.jsvcgen.client.RequestDispatcher;
import com.solidfire.jsvcgen.client.VersioningUtils;
import com.solidfire.jsvcgen.javautil.Consumer;
import com.solidfire.jsvcgen.javautil.Optional;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import net.iharder.Base64;

public class HttpsRequestDispatcher
implements RequestDispatcher {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    public static final int DEFAULT_READ_TIMEOUT = 60000;
    private final URL endpoint;
    private final Optional<String> authenticationToken;
    private final String endpointVersion;
    private int connectionTimeout;
    private int readTimeout;

    private HttpsRequestDispatcher(URL endpoint, Optional<String> authenticationToken) {
        if (!endpoint.getProtocol().equals("https")) {
            throw new IllegalArgumentException("Unsupported endpoint protocol \"" + endpoint.getProtocol() + "\"." + "Only \"https\" is supported.");
        }
        this.endpointVersion = VersioningUtils.getVersionFromEndpoint(endpoint);
        this.endpoint = endpoint;
        this.authenticationToken = authenticationToken;
        this.setTimeoutToDefault();
    }

    public HttpsRequestDispatcher(URL endpoint) {
        this(endpoint, Optional.empty());
    }

    public HttpsRequestDispatcher(URL endpoint, String username, String password) {
        this(endpoint, Optional.of(HttpsRequestDispatcher.createBasicAuthToken(username, password)));
    }

    @Override
    public String getVersion() {
        return this.endpointVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dispatchRequest(String input) throws IOException {
        byte[] encodedRequest = input.getBytes();
        HttpsURLConnection connection = (HttpsURLConnection)this.endpoint.openConnection();
        this.prepareConnection(connection);
        OutputStream out = connection.getOutputStream();
        Object object = null;
        try {
            out.write(encodedRequest);
            out.flush();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (object != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
        InputStream response = connection.getResponseCode() == 200 ? connection.getInputStream() : connection.getErrorStream();
        try {
            object = this.decodeResponse(response);
            return object;
        }
        finally {
            if (null != response) {
                response.close();
            }
        }
    }

    protected void prepareConnection(final HttpsURLConnection connection) {
        try {
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
        }
        catch (ProtocolException pe) {
            throw new RuntimeException("Your HTTP connection does not support \"POST\"", pe);
        }
        connection.addRequestProperty("Accept", "application/json");
        connection.setConnectTimeout(this.connectionTimeout);
        connection.setReadTimeout(this.readTimeout);
        this.authenticationToken.ifPresent(new Consumer<String>(){

            @Override
            public void accept(String token) {
                connection.addRequestProperty("Authorization", token);
            }
        });
    }

    protected String decodeResponse(InputStream response) throws IOException {
        try (Scanner s = new Scanner(response);){
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    private static String createBasicAuthToken(String username, String password) {
        return "Basic " + Base64.encodeBytes((byte[])(username + ":" + password).getBytes());
    }

    @Override
    public void setTimeoutToDefault() {
        this.connectionTimeout = 15000;
        this.readTimeout = 60000;
    }

    @Override
    public void setConnectionTimeout(int timeInMilliseconds) {
        if (timeInMilliseconds < 0) {
            throw new IllegalArgumentException("timeout can not be negative");
        }
        this.connectionTimeout = timeInMilliseconds;
    }

    @Override
    public void setReadTimeout(int timeInMilliseconds) {
        if (timeInMilliseconds < 0) {
            throw new IllegalArgumentException("timeout can not be negative");
        }
        this.readTimeout = timeInMilliseconds;
    }

    public URL getEndpoint() {
        return this.endpoint;
    }

    static {
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
    }
}

