/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.client;

import com.solidfire.gson.Gson;
import com.solidfire.gson.GsonBuilder;
import com.solidfire.gson.JsonElement;
import com.solidfire.gson.JsonObject;
import com.solidfire.gson.JsonParseException;
import com.solidfire.gson.stream.JsonReader;
import com.solidfire.jsvcgen.client.ApiException;
import com.solidfire.jsvcgen.client.ApiServerException;
import com.solidfire.jsvcgen.client.RequestDispatcher;
import com.solidfire.jsvcgen.client.VersioningUtils;
import com.solidfire.jsvcgen.serialization.ArrayAdaptorUtils;
import com.solidfire.jsvcgen.serialization.GsonUtil;
import com.solidfire.jsvcgen.serialization.OptionalAdaptorUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBase {
    private static final Logger log = LoggerFactory.getLogger(ServiceBase.class);
    private static final AtomicLong sessionId;
    private final RequestDispatcher requestDispatcher;
    private final GsonBuilder gsonBuilder = GsonUtil.getDefaultBuilder();

    protected ServiceBase(RequestDispatcher requestDispatcher) {
        this.requestDispatcher = requestDispatcher;
    }

    public final RequestDispatcher getRequestDispatcher() {
        return this.requestDispatcher;
    }

    protected final GsonBuilder getGsonBuilder() {
        return this.gsonBuilder;
    }

    public <TResult, TRequest> TResult sendRequest(String method, TRequest requestParams, Class<TRequest> requestParamsClass, Class<TResult> resultParamsClass) {
        Map<Method, Object> valuesOfMethodsWithGreaterVersion;
        if (null == method || method.trim().isEmpty()) {
            throw new IllegalArgumentException("method is null or empty");
        }
        if (null == requestParams) {
            throw new IllegalArgumentException("request params is null");
        }
        if (null == requestParamsClass) {
            throw new IllegalArgumentException("request params class is null");
        }
        if (null == resultParamsClass) {
            throw new IllegalArgumentException("result params class is null");
        }
        Map<String, Constructor<TRequest>> versionConstructorMap = VersioningUtils.mapConstructorVersions(requestParams);
        if (versionConstructorMap.size() > 1 && !(valuesOfMethodsWithGreaterVersion = VersioningUtils.getValuesOfMethodsWithGreaterVersion(requestParams, this.requestDispatcher.getVersion())).isEmpty()) {
            throw new ApiException("The following parameters(s) are not applicable to this version of the API. " + VersioningUtils.methodParametersToString(valuesOfMethodsWithGreaterVersion.keySet()));
        }
        String jsonRequest = this.encodeRequest(method, requestParams, requestParamsClass);
        log.debug("Request: {}", (Object)jsonRequest);
        try {
            String response = this.getRequestDispatcher().dispatchRequest(jsonRequest).replaceAll("\"attributes\":\"\"", "\"attributes\":null");
            return this.decodeResponse(response, resultParamsClass);
        }
        catch (IOException ioe) {
            throw new ApiException(ioe);
        }
    }

    protected <TRequest> String encodeRequest(String method, TRequest requestParams, Class<TRequest> requestParamsClass) {
        if (null == method || method.trim().isEmpty()) {
            throw new IllegalArgumentException("method is null or empty");
        }
        if (null == requestParams) {
            throw new IllegalArgumentException("request params is null");
        }
        if (null == requestParamsClass) {
            throw new IllegalArgumentException("request params class is null");
        }
        Gson gson = this.getGsonBuilder().create();
        JsonObject requestObj = new JsonObject();
        requestObj.addProperty("id", (Number)sessionId.incrementAndGet());
        requestObj.addProperty("method", method);
        requestObj.addProperty("json-rpc", "2.0");
        requestObj.add("params", gson.toJsonTree(requestParams, requestParamsClass));
        return gson.toJson((JsonElement)requestObj);
    }

    protected <TResult> TResult decodeResponse(String response, Class<TResult> resultParamsClass) {
        log.debug("Response: {}", (Object)response);
        Gson gson = this.getGsonBuilder().create();
        try {
            JsonReader reader = new JsonReader((Reader)new StringReader(response));
            reader.setLenient(true);
            JsonObject resultObj = (JsonObject)gson.fromJson(reader, JsonObject.class);
            this.checkForError(resultObj);
            Object result = gson.fromJson(resultObj.get("result"), resultParamsClass);
            OptionalAdaptorUtils.initializeAllNullOptionalFieldsAsEmpty(result);
            ArrayAdaptorUtils.convertAllArrayListsToArrays(result);
            return (TResult)result;
        }
        catch (ClassCastException e) {
            Pattern pattern = Pattern.compile("<p> (.*?)</p>");
            Matcher matcher = pattern.matcher(response);
            if (matcher.find()) {
                throw new ApiServerException("Not Found", "404", matcher.group(1));
            }
            throw new ApiException(String.format("There was a problem parsing the response from the server. ( response=%s )", response), e);
        }
        catch (JsonParseException | NullPointerException e) {
            log.debug(response);
            throw new ApiException(String.format("There was a problem parsing the response from the server. ( response=%s )", response), e);
        }
    }

    protected void checkForError(JsonObject resultObj) throws ApiServerException {
        if (resultObj.has("error")) {
            throw this.extractApiError(resultObj.get("error"));
        }
    }

    protected ApiServerException extractApiError(JsonElement errorElem) {
        return (ApiServerException)this.getGsonBuilder().create().fromJson(errorElem, ApiServerException.class);
    }

    static {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        sessionId = new AtomicLong(0L);
    }
}

