/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.javautil;

import com.solidfire.jsvcgen.javautil.Consumer;
import com.solidfire.jsvcgen.javautil.Function;
import com.solidfire.jsvcgen.javautil.Predicate;
import com.solidfire.jsvcgen.javautil.Supplier;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public final class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Optional<String> EMPTY_STRING = Optional.empty();
    public static final Optional<String[]> EMPTY_STRING_ARRAY = Optional.empty();
    public static final Optional<Long> EMPTY_LONG = Optional.empty();
    public static final Optional<Long[]> EMPTY_LONG_ARRAY = Optional.empty();
    public static final Optional<Double> EMPTY_DOUBLE = Optional.empty();
    public static final Optional<Double[]> EMPTY_DOUBLE_ARRAY = Optional.empty();
    public static final Optional<Map<String, Object>> EMPTY_MAP = Optional.empty();
    private final T value;
    private static final Optional<?> EMPTY = new Optional();

    private Optional() {
        this.value = null;
    }

    private Optional(T value) {
        if (value == null) {
            throw new NullPointerException("Cannot create Optional with a null value");
        }
        this.value = value;
    }

    public static <T> Optional<T> empty() {
        Optional<?> x = EMPTY;
        return x;
    }

    public static <T> Optional<T> of(T value) {
        if (value.getClass() == Optional.class) {
            return (Optional)value;
        }
        return new Optional<T>(value);
    }

    public static <T> Optional<T> ofNullable(T value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Optional) {
            Optional other = (Optional)obj;
            if (this.value == null) {
                return other.value == null;
            }
            if (other.value == null) {
                return false;
            }
            return this.value.equals(other.value);
        }
        return false;
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate cannot be null");
        }
        if (this.isPresent() && predicate.test(this.get())) {
            return this;
        }
        return Optional.empty();
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper cannot be null");
        }
        if (this.isPresent()) {
            return mapper.apply(this.get());
        }
        return Optional.empty();
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("Cannot get an Optional without a value");
        }
        return this.value;
    }

    public int hashCode() {
        return this.isPresent() ? this.value.hashCode() : 0;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer cannot be null");
        }
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper cannot be null");
        }
        if (this.isPresent()) {
            return new Optional<U>(mapper.apply(this.get()));
        }
        return Optional.empty();
    }

    public T orElse(T other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        if (other == null) {
            throw new NullPointerException("other cannot be null");
        }
        if (this.isPresent()) {
            return this.value;
        }
        return other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (exceptionSupplier == null) {
            throw new NullPointerException("exceptionSupplier cannot be null");
        }
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public String toString() {
        return this.map(new Function<T, String>(){

            @Override
            public String apply(T x) {
                return "Some(" + x.toString() + ")";
            }
        }).orElse("None");
    }
}

