/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.serialization;

import com.solidfire.gson.TypeAdapter;
import com.solidfire.gson.stream.JsonReader;
import com.solidfire.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Duration;

public class DurationAdapter
extends TypeAdapter<Duration> {
    private static final Pattern inputRegex = Pattern.compile("(-?)(?:(?:([0-9]+):)?([0-9]+):)?([0-9]+)(?:\\.([0-9]+))?");

    public static Class<Duration> serializingClass() {
        return Duration.class;
    }

    public Duration read(JsonReader reader) throws IOException {
        String input = reader.nextString();
        Matcher m = inputRegex.matcher(input);
        if (m.matches()) {
            String millisecondsSource;
            long hours = m.group(2) != null ? Long.parseLong(m.group(2)) : 0L;
            long minutes = m.group(3) != null ? Long.parseLong(m.group(3)) : 0L;
            long seconds = m.group(4) != null ? Long.parseLong(m.group(4)) : 0L;
            String string = millisecondsSource = m.group(5) != null ? m.group(5) : "000";
            while (millisecondsSource.length() < 3) {
                millisecondsSource = millisecondsSource + '0';
            }
            millisecondsSource = millisecondsSource.substring(0, 3);
            long millis = Long.parseLong(millisecondsSource);
            long millisTotal = ((hours * 60L + minutes) * 60L + seconds) * 1000L + millis;
            if (m.group(1).equals("-")) {
                millisTotal = -millisTotal;
            }
            return Duration.millis((long)millisTotal);
        }
        throw new RuntimeException("Could not extract duration from \"" + input + "\"");
    }

    public void write(JsonWriter writer, Duration value) throws IOException {
        String neg;
        long total = value.getMillis();
        String string = neg = total < 0L ? "-" : "";
        if (total < 0L) {
            total = -total;
        }
        long millis = total % 1000L;
        long seconds = (total /= 1000L) % 60L;
        long minutes = (total /= 60L) % 60L;
        long hours = total /= 60L;
        writer.value(String.format("%s%02d:%02d:%02d.%03d000", neg, hours, minutes, seconds, millis));
    }
}

