/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.serialization;

import com.solidfire.gson.InstanceCreator;
import com.solidfire.gson.JsonDeserializationContext;
import com.solidfire.gson.JsonDeserializer;
import com.solidfire.gson.JsonElement;
import com.solidfire.gson.JsonSerializationContext;
import com.solidfire.gson.JsonSerializer;
import com.solidfire.jsvcgen.javautil.Optional;
import com.solidfire.jsvcgen.serialization.OptionalAdaptorUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class OptionalAdapter
implements JsonSerializer<Optional<?>>,
JsonDeserializer<Optional<?>>,
InstanceCreator<Optional<?>> {
    public static Class serializingClass() {
        return Optional.class;
    }

    public Optional<?> createInstance(Type type) {
        return Optional.empty();
    }

    public JsonElement serialize(Optional<?> optional, Type type, JsonSerializationContext context) {
        if (!optional.isPresent()) {
            return null;
        }
        return context.serialize(optional.get());
    }

    public Optional<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        if (!(json.isJsonObject() || json.isJsonArray() || !json.isJsonNull() && json.getAsString() != null)) {
            return Optional.empty();
        }
        ParameterizedType pType = (ParameterizedType)typeOfT;
        Type genericType = pType.getActualTypeArguments()[0];
        if (genericType.equals(String.class)) {
            return Optional.of(json.getAsString());
        }
        if (!json.isJsonObject() && !json.isJsonArray() && json.getAsString().trim().length() == 0) {
            return Optional.empty();
        }
        if ((json.isJsonObject() || json.isJsonArray()) && json.isJsonNull()) {
            return Optional.empty();
        }
        if (genericType.equals(Integer.class)) {
            return Optional.of(json.getAsInt());
        }
        if (genericType.equals(Long.class)) {
            return Optional.of(json.getAsLong());
        }
        if (genericType.equals(Double.class)) {
            return Optional.of(json.getAsDouble());
        }
        Object obj = context.deserialize(json, genericType);
        OptionalAdaptorUtils.initializeAllNullOptionalFieldsAsEmpty(obj);
        return Optional.of(obj);
    }
}

