/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.serialization;

import com.solidfire.jsvcgen.javautil.Optional;
import com.solidfire.jsvcgen.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalAdaptorUtils {
    private static final Logger log = LoggerFactory.getLogger(OptionalAdaptorUtils.class);

    public static <T> T initializeAllNullOptionalFieldsAsEmpty(T obj) {
        if (!OptionalAdaptorUtils.hasOptionalFields(obj)) {
            return obj;
        }
        for (Map.Entry<Object, List<Field>> fieldEntry : OptionalAdaptorUtils.getOptionalFields(obj).entrySet()) {
            Object parentObject = fieldEntry.getKey();
            List<Field> fields = fieldEntry.getValue();
            for (Field field : fields) {
                if (ReflectionUtils.safeGet(field, parentObject) != null) continue;
                ReflectionUtils.safeSet(field, parentObject, Optional.empty());
            }
        }
        return obj;
    }

    public static boolean hasOptionalFields(Object obj) {
        if (obj == null || obj instanceof String) {
            return false;
        }
        if (obj.getClass().isArray() && obj.getClass().getComponentType().isPrimitive()) {
            return false;
        }
        if (obj.getClass().isArray() && !obj.getClass().isPrimitive()) {
            for (Object anObj : (Object[])obj) {
                if (!OptionalAdaptorUtils.hasOptionalFields(anObj)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Iterable) {
            for (Object anObj : (Iterable)obj) {
                if (!OptionalAdaptorUtils.hasOptionalFields(anObj)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Map) {
            for (Map.Entry anEntry : ((Map)obj).entrySet()) {
                if (!OptionalAdaptorUtils.hasOptionalFields(anEntry.getKey()) && !OptionalAdaptorUtils.hasOptionalFields(anEntry.getValue())) continue;
                return true;
            }
            return false;
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.getType().getName().startsWith("java.")) continue;
            if (field.getType() == Optional.class) {
                return true;
            }
            if (!OptionalAdaptorUtils.hasOptionalFields(ReflectionUtils.safeGet(field, obj))) continue;
            return true;
        }
        return false;
    }

    public static Map<Object, List<Field>> getOptionalFields(Object obj) {
        HashMap<Object, List<Field>> fieldMap = new HashMap<Object, List<Field>>();
        if (obj == null || obj instanceof String) {
            return fieldMap;
        }
        if (obj.getClass().isArray() && !obj.getClass().isPrimitive()) {
            for (Object anObj : (Object[])obj) {
                if (!OptionalAdaptorUtils.hasOptionalFields(anObj)) continue;
                fieldMap.putAll(OptionalAdaptorUtils.getOptionalFields(anObj));
            }
            return fieldMap;
        }
        if (obj instanceof Iterable) {
            for (Object anObj : (Iterable)obj) {
                if (!OptionalAdaptorUtils.hasOptionalFields(anObj)) continue;
                fieldMap.putAll(OptionalAdaptorUtils.getOptionalFields(anObj));
            }
            return fieldMap;
        }
        if (obj instanceof Map) {
            for (Map.Entry anEntry : ((Map)obj).entrySet()) {
                if (OptionalAdaptorUtils.hasOptionalFields(anEntry.getKey())) {
                    fieldMap.putAll(OptionalAdaptorUtils.getOptionalFields(anEntry.getKey()));
                }
                if (!OptionalAdaptorUtils.hasOptionalFields(anEntry.getValue())) continue;
                fieldMap.putAll(OptionalAdaptorUtils.getOptionalFields(anEntry.getValue()));
            }
            return fieldMap;
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.getType().getName().startsWith("java.")) continue;
            if (field.getType() == Optional.class) {
                if (!fieldMap.containsKey(obj)) {
                    fieldMap.put(obj, new ArrayList());
                }
                ((List)fieldMap.get(obj)).add(field);
                continue;
            }
            Object value = ReflectionUtils.safeGet(field, obj);
            if (!OptionalAdaptorUtils.hasOptionalFields(value)) continue;
            fieldMap.putAll(OptionalAdaptorUtils.getOptionalFields(value));
        }
        return fieldMap;
    }
}

