/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.client;

import com.solidfire.jsvcgen.annotation.Since;
import com.solidfire.jsvcgen.client.ApiException;
import com.solidfire.jsvcgen.javautil.Optional;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VersioningUtils {
    public static String getVersionFromEndpoint(URL endpoint) {
        for (String section : endpoint.toString().split("/")) {
            if (!VersioningUtils.isVersionString(section)) continue;
            return section;
        }
        throw new ApiException("Version missing in endpoint url");
    }

    public static boolean isVersionString(String possibleVersion) {
        return null != possibleVersion && !possibleVersion.trim().isEmpty() && possibleVersion.matches("^\\d{1,3}.\\d{1,2}$");
    }

    public static boolean isVersionGreater(String baseVersion, String checkedVersion) {
        return baseVersion.compareTo(checkedVersion) < 0;
    }

    public static boolean isVersionGreaterOrEqual(String baseVersion, String checkedVersion) {
        return baseVersion.compareTo(checkedVersion) <= 0;
    }

    public static boolean isVersionLess(String baseVersion, String checkedVersion) {
        return baseVersion.compareTo(checkedVersion) > 0;
    }

    public static boolean isVersionLessOrEqual(String baseVersion, String checkedVersion) {
        return baseVersion.compareTo(checkedVersion) >= 0;
    }

    public static <T> Map<String, Constructor<T>> mapConstructorVersions(T object) {
        HashMap<String, Constructor<T>> versionConstructorMap = new HashMap<String, Constructor<T>>(object.getClass().getConstructors().length);
        for (Constructor<?> constructor : object.getClass().getConstructors()) {
            Since sinceAnnotation = constructor.getAnnotation(Since.class);
            Since since = sinceAnnotation;
            if (null == since) continue;
            versionConstructorMap.put(since.value(), constructor);
        }
        return versionConstructorMap;
    }

    public static <T> Map<String, Constructor<T>> mapConstructorVersionsLargerThan(T object, String baseVersion) {
        Map<String, Constructor<T>> versionConstructorMap = VersioningUtils.mapConstructorVersions(object);
        HashMap<String, Constructor<T>> filteredVersionConstructorMap = new HashMap<String, Constructor<T>>(versionConstructorMap.size());
        for (Map.Entry<String, Constructor<T>> entry : versionConstructorMap.entrySet()) {
            if (!VersioningUtils.isVersionGreater(baseVersion, entry.getKey())) continue;
            filteredVersionConstructorMap.put(entry.getKey(), entry.getValue());
        }
        return filteredVersionConstructorMap;
    }

    public static <T> List<Method> getMethodsOfGreaterVersion(T object, String baseVersion) {
        ArrayList<Method> methodsWithGreaterVersion = new ArrayList<Method>();
        for (Method method : object.getClass().getDeclaredMethods()) {
            Since sinceAnnotation = method.getAnnotation(Since.class);
            Since since = sinceAnnotation;
            if (null == since || !VersioningUtils.isVersionGreater(baseVersion, since.value())) continue;
            methodsWithGreaterVersion.add(method);
        }
        return methodsWithGreaterVersion;
    }

    public static <T> Map<Method, Object> getValuesOfMethodsWithGreaterVersion(T object, String baseVersion) {
        LinkedHashMap<Method, Object> valuesOfMethodsWithGreaterVersion = new LinkedHashMap<Method, Object>();
        for (Method method : VersioningUtils.getMethodsOfGreaterVersion(object, baseVersion)) {
            try {
                Object value = method.invoke(object, new Object[0]);
                if (value == null || Optional.empty().equals(value)) continue;
                valuesOfMethodsWithGreaterVersion.put(method, value);
            }
            catch (ReflectiveOperationException e) {}
        }
        return valuesOfMethodsWithGreaterVersion;
    }

    public static List<String> transformMethodsToParameterNames(List<Method> methods) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (Method method : methods) {
            String methodName = method.getName().replace("get", "");
            parameterNames.add(methodName.substring(0, 1).toLowerCase() + methodName.substring(1));
        }
        return parameterNames;
    }

    public static String methodParametersToString(Collection<Method> methods) {
        return Arrays.toString(VersioningUtils.transformMethodsToParameterNames(new ArrayList<Method>(methods)).toArray());
    }
}

