/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.reflection;

import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static <T> T safeGet(Field field, Object obj) {
        try {
            boolean accessibility = field.isAccessible();
            field.setAccessible(true);
            Object value = field.get(obj);
            field.setAccessible(accessibility);
            return (T)value;
        }
        catch (IllegalAccessException e) {
            log.debug("Error getting field {} value from {}", (Object)field, (Object)obj.getClass().getSimpleName());
            return null;
        }
    }

    public static <T> void safeSet(Field field, Object obj, T value) {
        try {
            boolean accessibility = field.isAccessible();
            field.setAccessible(true);
            field.set(obj, value);
            field.setAccessible(accessibility);
        }
        catch (IllegalAccessException e) {
            log.debug("Error setting field {} in {} with value {}", new Object[]{field, obj.getClass().getSimpleName(), value});
        }
    }
}

