/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.serialization;

import com.solidfire.jsvcgen.javautil.Optional;
import com.solidfire.jsvcgen.reflection.ReflectionUtils;
import com.solidfire.jsvcgen.serialization.OptionalAdaptorUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayAdaptorUtils {
    private static final Logger log = LoggerFactory.getLogger(OptionalAdaptorUtils.class);

    public static <T> T convertAllArrayListsToArrays(T obj) {
        if (!ArrayAdaptorUtils.hasMapFields(obj)) {
            return obj;
        }
        ArrayAdaptorUtils.convert(ArrayAdaptorUtils.getConvertibleMaps(obj));
        return obj;
    }

    private static void convert(Map<Map<String, Object>, Map<String, List>> conversionMap) {
        for (Map.Entry<Map<String, Object>, Map<String, List>> entry : conversionMap.entrySet()) {
            for (Map.Entry<String, List> convertibleEntry : entry.getValue().entrySet()) {
                entry.getKey().put(convertibleEntry.getKey(), convertibleEntry.getValue().toArray());
            }
        }
    }

    private static <T> Map<Map<String, Object>, Map<String, List>> getConvertibleMaps(T obj) {
        HashMap<Map<String, Object>, Map<String, List>> conversionMap = new HashMap<Map<String, Object>, Map<String, List>>();
        for (Map<String, Object> map : ArrayAdaptorUtils.getAllMaps(obj)) {
            conversionMap.put(map, new HashMap());
            for (Map.Entry<String, Object> mapEntry : map.entrySet()) {
                if (!(mapEntry.getValue() instanceof List)) continue;
                ((Map)conversionMap.get(map)).put(mapEntry.getKey(), (List)mapEntry.getValue());
            }
        }
        return conversionMap;
    }

    public static boolean hasMapFields(Object obj) {
        if (obj == null || obj instanceof String) {
            return false;
        }
        if (obj.getClass().isArray() && obj.getClass().getComponentType().isPrimitive()) {
            return false;
        }
        if (obj instanceof Optional) {
            return ((Optional)obj).isPresent() && ArrayAdaptorUtils.hasMapFields(((Optional)obj).get());
        }
        if (obj.getClass().isArray() && !obj.getClass().isPrimitive()) {
            for (Object anObj : (Object[])obj) {
                if (!ArrayAdaptorUtils.hasMapFields(anObj)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Iterable) {
            for (Object anObj : (Iterable)obj) {
                if (!ArrayAdaptorUtils.hasMapFields(anObj)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Map) {
            return true;
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.getType().getName().startsWith("java") && !field.getType().getName().startsWith("java.util") || !ArrayAdaptorUtils.hasMapFields(ReflectionUtils.safeGet(field, obj))) continue;
            return true;
        }
        return false;
    }

    public static List<Map<String, Object>> getAllMaps(Object obj) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        if (obj == null || obj instanceof String) {
            return maps;
        }
        if (obj.getClass().isArray() && !obj.getClass().isPrimitive()) {
            for (Object anObj : (Object[])obj) {
                if (!ArrayAdaptorUtils.hasMapFields(anObj)) continue;
                maps.addAll(ArrayAdaptorUtils.getAllMaps(anObj));
            }
            return maps;
        }
        if (obj instanceof Map) {
            maps.add((Map)obj);
            for (Map.Entry anEntry : ((Map)obj).entrySet()) {
                if (ArrayAdaptorUtils.hasMapFields(anEntry.getKey())) {
                    maps.addAll(ArrayAdaptorUtils.getAllMaps(anEntry.getKey()));
                }
                maps.addAll(ArrayAdaptorUtils.getAllMaps(anEntry.getValue()));
            }
            return maps;
        }
        if (obj instanceof Optional && ((Optional)obj).isPresent()) {
            maps.addAll(ArrayAdaptorUtils.getAllMaps(((Optional)obj).get()));
            return maps;
        }
        if (obj instanceof Iterable) {
            for (Object anObj : (Iterable)obj) {
                if (!ArrayAdaptorUtils.hasMapFields(anObj)) continue;
                maps.addAll(ArrayAdaptorUtils.getAllMaps(anObj));
            }
            return maps;
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.getType().getName().startsWith("java") && !field.getType().getName().startsWith("java.util") || !(ReflectionUtils.safeGet(field, obj) instanceof Map)) continue;
            Map map = (Map)ReflectionUtils.safeGet(field, obj);
            maps.add(map);
        }
        return maps;
    }
}

