/*
 * Decompiled with CFR 0.152.
 */
package spark.template.jinjava;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.lib.fn.ELFunctionDefinition;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.loader.FileLocator;
import com.hubspot.jinjava.loader.ResourceLocator;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import spark.ModelAndView;
import spark.TemplateEngine;

public class JinjavaEngine
extends TemplateEngine {
    private Jinjava jinjava;
    private Context context;

    public JinjavaEngine() {
        this(new JinjavaConfig());
    }

    public JinjavaEngine(JinjavaConfig jinjavaConfig) {
        this(jinjavaConfig, (ResourceLocator)new FileLocator());
    }

    public JinjavaEngine(JinjavaConfig jinjavaConfig, ResourceLocator resourceLocator) {
        this.jinjava = new Jinjava(jinjavaConfig);
        this.jinjava.setResourceLocator(resourceLocator);
        this.context = this.jinjava.getGlobalContext();
    }

    public void registerTag(Tag tag) {
        this.context.registerTag(tag);
    }

    public void registerFilter(Filter filter) {
        this.context.registerFilter(filter);
    }

    public void registerFunction(ELFunctionDefinition function) {
        this.context.registerFunction(function);
    }

    public String render(ModelAndView modelAndView) {
        Object model = modelAndView.getModel();
        if (model instanceof Map) {
            String template = null;
            try {
                template = Resources.toString((URL)Resources.getResource((String)modelAndView.getViewName()), (Charset)Charsets.UTF_8);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            return this.jinjava.render(template, (Map)model);
        }
        throw new IllegalArgumentException("modelAndView.getModel() must return a java.util.Map");
    }
}

