/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.generator.ColumnDataGeneratorSetting;
import com.sqlapp.data.db.command.generator.GeneratorSettingWorkbook;
import com.sqlapp.data.db.command.generator.QueryDefinitionDataGeneratorSetting;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.exceptions.ExpressionExecutionException;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.eval.CachedEvaluator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class TableDataGeneratorSetting {
    private String name;
    private long numberOfRows;
    private Map<String, ColumnDataGeneratorSetting> columns = CommonUtils.caseInsensitiveLinkedMap();
    private Map<String, QueryDefinitionDataGeneratorSetting> queryDefinitions = new LinkedHashMap<String, QueryDefinitionDataGeneratorSetting>();
    private Map<Integer, ColumnDataGeneratorSetting> columnIndexs = new LinkedHashMap<Integer, ColumnDataGeneratorSetting>();
    private CachedEvaluator evaluator;
    public static final String START_KEY = "_start";
    public static final String MAX_KEY = "_max";
    public static final String INDEX_KEY = "_index";
    public static final String PREVIOUS_KEY = "_previous";
    private ParametersContext startValues = new ParametersContext();
    private ParametersContext maxValues = new ParametersContext();
    private Map<String, Object> previousValues = Collections.emptyMap();

    public void addColumn(ColumnDataGeneratorSetting col, int index) {
        this.columns.put(col.getName(), col);
        this.columnIndexs.put(index, col);
    }

    public void addQueryDefinition(QueryDefinitionDataGeneratorSetting obj, int index) {
        this.queryDefinitions.put(obj.getGenerationGroup(), obj);
    }

    public void check() {
        this.columns.entrySet().forEach(entry -> {
            String genGroup = ((ColumnDataGeneratorSetting)entry.getValue()).getGenerationGroup();
            if (!CommonUtils.isEmpty((CharSequence)genGroup)) {
                QueryDefinitionDataGeneratorSetting queryDef = this.queryDefinitions.get(genGroup);
                ((ColumnDataGeneratorSetting)entry.getValue()).setQueryDefinitionDataGeneratorSetting(queryDef);
            }
        });
    }

    public synchronized void calculateInitialValues() {
        this.columns.entrySet().forEach(entry -> {
            ColumnDataGeneratorSetting colSetting = (ColumnDataGeneratorSetting)entry.getValue();
            String expression = colSetting.getStartValue();
            if (!CommonUtils.isEmpty((CharSequence)expression)) {
                try {
                    Object value = this.evaluator.getEvalExecutor(expression).eval(Collections.emptyMap());
                    colSetting.setStartValueObject(value);
                    this.startValues.put(colSetting.getName(), value);
                }
                catch (RuntimeException e) {
                    throw new ExpressionExecutionException("Column expression is invalid. column=[" + GeneratorSettingWorkbook.Column.name() + "!" + colSetting.getColString() + "5]", (Throwable)e);
                }
            }
        });
        Map map = CommonUtils.map();
        map.put(START_KEY, this.startValues);
        this.columns.entrySet().forEach(entry -> {
            ColumnDataGeneratorSetting colSetting = (ColumnDataGeneratorSetting)entry.getValue();
            String expression = colSetting.getMaxValue();
            if (!CommonUtils.isEmpty((CharSequence)expression)) {
                try {
                    Object value = this.evaluator.getEvalExecutor(expression).eval((Object)map);
                    colSetting.setMaxValueObject(value);
                    this.maxValues.put(colSetting.getName(), value);
                }
                catch (RuntimeException e) {
                    throw new ExpressionExecutionException("Column expression is invalid. column=[" + GeneratorSettingWorkbook.Column.name() + "!" + colSetting.getColString() + "6]", (Throwable)e);
                }
            }
        });
    }

    public Map<String, Object> generateValue(long index) {
        Map map = CommonUtils.map();
        map.put(INDEX_KEY, index);
        map.put(PREVIOUS_KEY, this.previousValues);
        map.put(START_KEY, this.startValues);
        map.put(MAX_KEY, this.maxValues);
        int intIndex = (int)(index % Integer.MAX_VALUE);
        for (Map.Entry<String, ColumnDataGeneratorSetting> entry : this.columns.entrySet()) {
            Object value;
            ColumnDataGeneratorSetting colSetting = entry.getValue();
            if (colSetting.getQueryDefinitionDataGeneratorSetting() != null) {
                Map<String, Object> queryValueMap = colSetting.getQueryDefinitionDataGeneratorSetting().getValueMap(intIndex);
                map.put(colSetting.getName(), queryValueMap.get(colSetting.getName()));
                continue;
            }
            Optional<Object> op = colSetting.getValue(intIndex);
            if (op.isPresent()) {
                map.put(colSetting.getName(), op.get());
                continue;
            }
            if (index == 0L || CommonUtils.isEmpty((CharSequence)colSetting.getNextValue())) {
                map.put(colSetting.getName(), colSetting.getStartValueObject());
                continue;
            }
            String expression = colSetting.getNextValue();
            try {
                value = this.evaluator.getEvalExecutor(expression).eval((Object)map);
            }
            catch (RuntimeException e) {
                throw new ExpressionExecutionException("Column expression is invalid. column=[" + GeneratorSettingWorkbook.Column.name() + "!" + colSetting.getColString() + "7]", (Throwable)e);
            }
            if (colSetting.getMaxValueObject() != null) {
                int comp = this.compare(colSetting.getMaxValueObject(), value);
                if (comp > 0) {
                    map.put(colSetting.getName(), value);
                    continue;
                }
                map.put(colSetting.getName(), colSetting.getStartValueObject());
                continue;
            }
            map.put(colSetting.getName(), value);
        }
        this.previousValues = map;
        return map;
    }

    private int compare(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getClass().equals(o2.getClass()) && o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        Object o2conv = Converters.getDefault().convertObject(o2, o1.getClass());
        return ((Comparable)o1).compareTo(o2conv);
    }

    public void loadData(Connection conn) throws SQLException {
        for (Map.Entry<String, QueryDefinitionDataGeneratorSetting> entry : this.queryDefinitions.entrySet()) {
            entry.getValue().loadData(conn);
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    @Generated
    public Map<String, ColumnDataGeneratorSetting> getColumns() {
        return this.columns;
    }

    @Generated
    public Map<String, QueryDefinitionDataGeneratorSetting> getQueryDefinitions() {
        return this.queryDefinitions;
    }

    @Generated
    public Map<Integer, ColumnDataGeneratorSetting> getColumnIndexs() {
        return this.columnIndexs;
    }

    @Generated
    public CachedEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Generated
    public ParametersContext getStartValues() {
        return this.startValues;
    }

    @Generated
    public ParametersContext getMaxValues() {
        return this.maxValues;
    }

    @Generated
    public Map<String, Object> getPreviousValues() {
        return this.previousValues;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setNumberOfRows(long numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    @Generated
    public void setColumns(Map<String, ColumnDataGeneratorSetting> columns) {
        this.columns = columns;
    }

    @Generated
    public void setQueryDefinitions(Map<String, QueryDefinitionDataGeneratorSetting> queryDefinitions) {
        this.queryDefinitions = queryDefinitions;
    }

    @Generated
    public void setColumnIndexs(Map<Integer, ColumnDataGeneratorSetting> columnIndexs) {
        this.columnIndexs = columnIndexs;
    }

    @Generated
    public void setEvaluator(CachedEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Generated
    public void setStartValues(ParametersContext startValues) {
        this.startValues = startValues;
    }

    @Generated
    public void setMaxValues(ParametersContext maxValues) {
        this.maxValues = maxValues;
    }

    @Generated
    public void setPreviousValues(Map<String, Object> previousValues) {
        this.previousValues = previousValues;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableDataGeneratorSetting)) {
            return false;
        }
        TableDataGeneratorSetting other = (TableDataGeneratorSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumberOfRows() != other.getNumberOfRows()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, ColumnDataGeneratorSetting> this$columns = this.getColumns();
        Map<String, ColumnDataGeneratorSetting> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, QueryDefinitionDataGeneratorSetting> this$queryDefinitions = this.getQueryDefinitions();
        Map<String, QueryDefinitionDataGeneratorSetting> other$queryDefinitions = other.getQueryDefinitions();
        if (this$queryDefinitions == null ? other$queryDefinitions != null : !((Object)this$queryDefinitions).equals(other$queryDefinitions)) {
            return false;
        }
        Map<Integer, ColumnDataGeneratorSetting> this$columnIndexs = this.getColumnIndexs();
        Map<Integer, ColumnDataGeneratorSetting> other$columnIndexs = other.getColumnIndexs();
        if (this$columnIndexs == null ? other$columnIndexs != null : !((Object)this$columnIndexs).equals(other$columnIndexs)) {
            return false;
        }
        CachedEvaluator this$evaluator = this.getEvaluator();
        CachedEvaluator other$evaluator = other.getEvaluator();
        if (this$evaluator == null ? other$evaluator != null : !this$evaluator.equals(other$evaluator)) {
            return false;
        }
        ParametersContext this$startValues = this.getStartValues();
        ParametersContext other$startValues = other.getStartValues();
        if (this$startValues == null ? other$startValues != null : !this$startValues.equals(other$startValues)) {
            return false;
        }
        ParametersContext this$maxValues = this.getMaxValues();
        ParametersContext other$maxValues = other.getMaxValues();
        if (this$maxValues == null ? other$maxValues != null : !this$maxValues.equals(other$maxValues)) {
            return false;
        }
        Map<String, Object> this$previousValues = this.getPreviousValues();
        Map<String, Object> other$previousValues = other.getPreviousValues();
        return !(this$previousValues == null ? other$previousValues != null : !((Object)this$previousValues).equals(other$previousValues));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableDataGeneratorSetting;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $numberOfRows = this.getNumberOfRows();
        result = result * 59 + (int)($numberOfRows >>> 32 ^ $numberOfRows);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, ColumnDataGeneratorSetting> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, QueryDefinitionDataGeneratorSetting> $queryDefinitions = this.getQueryDefinitions();
        result = result * 59 + ($queryDefinitions == null ? 43 : ((Object)$queryDefinitions).hashCode());
        Map<Integer, ColumnDataGeneratorSetting> $columnIndexs = this.getColumnIndexs();
        result = result * 59 + ($columnIndexs == null ? 43 : ((Object)$columnIndexs).hashCode());
        CachedEvaluator $evaluator = this.getEvaluator();
        result = result * 59 + ($evaluator == null ? 43 : $evaluator.hashCode());
        ParametersContext $startValues = this.getStartValues();
        result = result * 59 + ($startValues == null ? 43 : $startValues.hashCode());
        ParametersContext $maxValues = this.getMaxValues();
        result = result * 59 + ($maxValues == null ? 43 : $maxValues.hashCode());
        Map<String, Object> $previousValues = this.getPreviousValues();
        result = result * 59 + ($previousValues == null ? 43 : ((Object)$previousValues).hashCode());
        return result;
    }
}

