/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.AbstractDataSourceCommand;
import com.sqlapp.data.db.command.generator.ColumnDataGeneratorSetting;
import com.sqlapp.data.db.command.generator.GeneratorSettingWorkbook;
import com.sqlapp.data.db.command.generator.MultiTableFoundException;
import com.sqlapp.data.db.command.generator.TableDataGeneratorSetting;
import com.sqlapp.data.db.command.generator.TableNotFoundException;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.function.ColumnPredicate;
import com.sqlapp.data.schemas.function.ColumnStringFunction;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.jdbc.sql.JdbcBatchUpdateHandler;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.eval.CachedEvaluator;
import com.sqlapp.util.eval.mvel.CachedMvelEvaluator;
import com.sqlapp.util.eval.mvel.ParserContextFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.mvel2.ParserContext;

public class GenerateDataInsertCommand
extends AbstractDataSourceCommand {
    private String schemaName;
    private String tableName;
    private SqlType sqlType = SqlType.INSERT;
    private File settingDirectory = new File("./");
    private long queryCommitInterval = Long.MAX_VALUE;
    private TableOptions tableOptions = new TableOptions();
    private CachedEvaluator evaluator = new CachedMvelEvaluator();

    @Override
    protected void doRun() {
        Map<String, TableDataGeneratorSetting> tableSettings;
        if (this.evaluator == null) {
            CachedMvelEvaluator ceval = new CachedMvelEvaluator();
            ParserContext mvelParserContext = ParserContextFactory.getInstance().getParserContext();
            ceval.setParserContext(mvelParserContext);
            this.evaluator = ceval;
        }
        try {
            tableSettings = this.readSetting();
        }
        catch (IOException | EncryptedDocumentException | InvalidFormatException e) {
            throw new RuntimeException(e);
        }
        if (tableSettings.isEmpty()) {
            this.info((Object)("File not found. settingDirectory" + this.settingDirectory.getAbsolutePath()));
            return;
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
            Dialect dialect = this.getDialect(connection);
            CatalogReader catalogReader = dialect.getCatalogReader();
            TableReader tableReader = catalogReader.getSchemaReader().getTableReader();
            tableReader.setSchemaName(this.getSchemaName());
            tableReader.setObjectName(this.getTableName());
            List tableList = tableReader.getAllFull(connection);
            if (tableList.isEmpty()) {
                throw new TableNotFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName());
            }
            if (tableList.isEmpty()) {
                throw new MultiTableFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", tableSize=" + tableList.size());
            }
            for (Table table : tableList) {
                TableDataGeneratorSetting tableSetting = tableSettings.get(table.getName());
                if (tableSetting == null) continue;
                tableSetting.loadData(connection);
                tableSetting.setEvaluator(this.evaluator);
                tableSetting.calculateInitialValues();
                connection.setAutoCommit(false);
                this.applyFromFileByRow(connection, dialect, table, tableSetting);
                tableSettings.remove(table.getName());
                connection.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    protected void applyFromFileByRow(Connection connection, Dialect dialect, Table table, TableDataGeneratorSetting tableSetting) throws Exception {
        SqlFactoryRegistry sqlFactoryRegistry = dialect.createSqlFactoryRegistry();
        sqlFactoryRegistry.getOption().setTableOptions(this.tableOptions.clone());
        sqlFactoryRegistry.getOption().getTableOptions().setInsertableColumn((ColumnPredicate & Serializable)c -> {
            ColumnDataGeneratorSetting colSetting = tableSetting.getColumns().get(c.getName());
            return colSetting != null && !colSetting.isInsertExclude();
        });
        sqlFactoryRegistry.getOption().getTableOptions().setParameterExpression((ColumnStringFunction & Serializable)(c, v) -> {
            ColumnDataGeneratorSetting colSetting = tableSetting.getColumns().get(c.getName());
            if (colSetting == null || CommonUtils.isEmpty((CharSequence)colSetting.getInsertSqlExpression())) {
                return (String)sqlFactoryRegistry.getOption().getTableOptions().getOriginalParameterExpression().apply(c, v);
            }
            return colSetting.getInsertSqlExpression();
        });
        SqlFactory factory = sqlFactoryRegistry.getSqlFactory((DbCommonObject)table, this.getSqlType());
        long queryCount = 0L;
        SqlConverter sqlConverter = this.getSqlConverter();
        List operations = factory.createSql((DbCommonObject)table);
        long total = tableSetting.getNumberOfRows();
        LocalDateTime startLocalTime = LocalDateTime.now();
        long start = System.currentTimeMillis();
        int batchSize = (Integer)this.getTableOptions().getDmlBatchSize().apply((Object)table);
        List batchRows = CommonUtils.list((int)batchSize);
        try {
            int batchRowSize;
            List handlers = operations.stream().map(c -> {
                ParametersContext context = new ParametersContext();
                context.putAll(this.getContext());
                SqlNode sqlNode = sqlConverter.parseSql(context, c.getSqlText());
                this.debug((Object)sqlNode);
                JdbcBatchUpdateHandler jdbcHandler = new JdbcBatchUpdateHandler(sqlNode);
                jdbcHandler.setDialect(dialect);
                return jdbcHandler;
            }).collect(Collectors.toList());
            long oneper = total / 100L;
            long pointTime1 = System.currentTimeMillis();
            this.info("==== ", table.getName(), " insert start. numberOfRows=[" + total + "]. batchSize=[", batchSize, "]. start=[", startLocalTime, "]. ==== ");
            for (long i = 0L; i < total; ++i) {
                Map<String, Object> vals = tableSetting.generateValue(i);
                ParametersContext context = this.convertDataType(vals, table);
                context.putAll(this.getContext());
                batchRows.add(context);
                batchRowSize = batchRows.size();
                if ((i + 1L) % oneper == 0L) {
                    long pointTime2 = System.currentTimeMillis();
                    this.info(String.format("%3s", (i + 1L) / oneper), "% insert completed.[", String.format("%3s", i + 1L), "/", total, "]. [", pointTime2 - pointTime1, " ms]");
                    pointTime1 = pointTime2;
                }
                if (batchRowSize < batchSize) continue;
                long pointTime3 = System.currentTimeMillis();
                for (JdbcBatchUpdateHandler jdbcHandler : handlers) {
                    jdbcHandler.execute(connection, (Object)batchRows);
                    long pointTime4 = System.currentTimeMillis();
                    this.debug("execute query batch size=[", batchRowSize, "]. [", pointTime4 - pointTime3, " ms]");
                    queryCount = this.commit(connection, queryCount);
                    pointTime1 = pointTime4;
                }
                batchRows.clear();
            }
            batchRowSize = batchRows.size();
            if (batchRowSize > 0) {
                for (JdbcBatchUpdateHandler jdbcHandler : handlers) {
                    jdbcHandler.execute(connection, (Object)batchRows);
                }
                this.debug("execute query batch size=", batchRowSize);
                this.commit(connection);
                batchRows.clear();
            }
        }
        catch (Exception e) {
            connection.rollback();
            throw e;
        }
        finally {
            table.setRowIteratorHandler(null);
        }
        long end = System.currentTimeMillis();
        LocalDateTime endLocalTime = LocalDateTime.now();
        this.info("==== ", table.getName(), " insert completed. numberOfRows=[", total, "]. start=[", startLocalTime, "]. end=[", endLocalTime, "]. [", end - start, " ms]. ==== ");
    }

    private ParametersContext convertDataType(Map<String, Object> map, Table table) {
        ParametersContext context = new ParametersContext();
        context.putAll(map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Column column = (Column)table.getColumns().get(entry.getKey());
            if (column == null) continue;
            Object val = Converters.getDefault().convertObject(entry.getValue(), column.getDataType().getDefaultClass());
            context.put(entry.getKey(), val);
        }
        return context;
    }

    private Map<String, TableDataGeneratorSetting> readSetting() throws EncryptedDocumentException, InvalidFormatException, IOException {
        Map ret = CommonUtils.caseInsensitiveMap();
        for (File file : this.settingDirectory.listFiles((dir, f) -> f.endsWith(".xlsx"))) {
            try (Workbook wb = WorkbookFileType.createWorkBook((File)file, null, (boolean)true);){
                TableDataGeneratorSetting setting = GeneratorSettingWorkbook.readWorkbook(wb);
                ret.put(setting.getName(), setting);
            }
        }
        return ret;
    }

    private long commit(Connection connection, long queryCount) throws SQLException {
        if (queryCount + 1L >= this.getQueryCommitInterval()) {
            this.commit(connection);
            return 0L;
        }
        return queryCount + 1L;
    }

    private void commit(Connection connection) throws SQLException {
        connection.commit();
        this.debug((Object)"commit");
    }

    protected SqlConverter getSqlConverter() {
        SqlConverter sqlConverter = new SqlConverter();
        return sqlConverter;
    }

    public void setDmlBatchSize(int batchSize) {
        this.getTableOptions().setDmlBatchSize(batchSize);
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Generated
    public File getSettingDirectory() {
        return this.settingDirectory;
    }

    @Generated
    public long getQueryCommitInterval() {
        return this.queryCommitInterval;
    }

    @Generated
    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    @Generated
    public CachedEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    @Generated
    public void setSettingDirectory(File settingDirectory) {
        this.settingDirectory = settingDirectory;
    }

    @Generated
    public void setQueryCommitInterval(long queryCommitInterval) {
        this.queryCommitInterval = queryCommitInterval;
    }

    @Generated
    public void setTableOptions(TableOptions tableOptions) {
        this.tableOptions = tableOptions;
    }

    @Generated
    public void setEvaluator(CachedEvaluator evaluator) {
        this.evaluator = evaluator;
    }
}

