/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.sqlapp.data.db.command.AbstractDataSourceCommand;
import com.sqlapp.data.db.command.generator.GeneratorSettingFileType;
import com.sqlapp.data.db.command.generator.GeneratorSettingWorkbook;
import com.sqlapp.data.db.command.generator.MultiTableFoundException;
import com.sqlapp.data.db.command.generator.TableDataGeneratorSetting;
import com.sqlapp.data.db.command.generator.TableNotFoundException;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.JsonConverter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Workbook;

public class OutputGenerateDataTemplateCommand
extends AbstractDataSourceCommand {
    private String schemaName;
    private String tableName;
    private SqlType sqlType = SqlType.INSERT_ROW;
    private File outputDirectory = new File("./");
    private GeneratorSettingFileType fileType = GeneratorSettingFileType.EXCEL2007;

    @Override
    protected void doRun() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            Dialect dialect = this.getDialect(connection);
            CatalogReader catalogReader = dialect.getCatalogReader();
            TableReader tableReader = catalogReader.getSchemaReader().getTableReader();
            tableReader.setSchemaName(this.getSchemaName());
            tableReader.setObjectName(this.getTableName());
            List tableList = tableReader.getAllFull(connection);
            if (tableList.isEmpty()) {
                throw new TableNotFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName());
            }
            if (tableList.isEmpty()) {
                throw new MultiTableFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", tableSize=" + tableList.size());
            }
            File dir = this.getOutputDirectory();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            for (Table table : tableList) {
                this.writeFile(table, dir);
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    private void writeFile(Table table, File dir) throws FileNotFoundException, IOException {
        switch (this.getFileType()) {
            case JSON: 
            case YAML: {
                this.writeTextFile(table, dir);
                break;
            }
            default: {
                this.writeFileWorkbook(table, dir);
            }
        }
    }

    private void writeTextFile(Table table, File dir) throws FileNotFoundException, IOException {
        TableDataGeneratorSetting setting = new TableDataGeneratorSetting();
        GeneratorSettingWorkbook.Table.setObjectValue(table, setting);
        GeneratorSettingWorkbook.Column.setObjectValue(table, setting);
        GeneratorSettingWorkbook.QueryDefinition.setObjectValue(table, setting);
        JsonConverter jsonConverter = this.getFileType().getWorkbookFileType().createJsonConverter();
        jsonConverter.setIndentOutput(true);
        String text = jsonConverter.toJsonString((Object)setting);
        FileUtils.write((File)new File(dir, table.getName() + "." + this.getFileType().getWorkbookFileType().getFileExtension()), (CharSequence)text, (Charset)Charset.forName("UTF-8"));
    }

    private void writeFileWorkbook(Table table, File dir) throws FileNotFoundException, IOException {
        try (Workbook wb = this.getFileType().getWorkbookFileType().createWorkbook();){
            GeneratorSettingWorkbook.Table.writeSheet(table, wb);
            GeneratorSettingWorkbook.Column.writeSheet(table, wb);
            GeneratorSettingWorkbook.QueryDefinition.writeSheet(table, wb);
            File file = new File(dir, table.getName() + ".xlsx");
            try (FileOutputStream os = new FileOutputStream(file);
                 BufferedOutputStream bs = new BufferedOutputStream(os);){
                wb.write((OutputStream)bs);
                bs.flush();
            }
        }
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Generated
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public GeneratorSettingFileType getFileType() {
        return this.fileType;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    @Generated
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Generated
    public void setFileType(GeneratorSettingFileType fileType) {
        this.fileType = fileType;
    }
}

