/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.Converter;
import com.sqlapp.util.CommonUtils;
import java.sql.SQLException;

public abstract class AbstractToObjectConverter<T, U>
extends AbstractConverter<T> {
    private static final long serialVersionUID = 6488632910509733050L;
    private Converter<U> converter;

    protected AbstractToObjectConverter(Converter<U> converter) {
        this.converter = converter;
    }

    public T convertObject(Object value) {
        if (CommonUtils.isEmpty((Object)value)) {
            return (T)this.getDefaultValue();
        }
        if (this.isTargetInstanceof(value)) {
            return (T)value;
        }
        if (value instanceof String) {
            String val = (String)value;
            T ret = this.newInstance();
            try {
                this.setValue(ret, val);
                return ret;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        Object obj = this.converter.convertObject(value);
        return this.toDbType(obj);
    }

    protected abstract boolean isTargetInstanceof(Object var1);

    protected abstract T newInstance();

    protected abstract T toDbType(U var1);

    protected abstract void setValue(T var1, String var2) throws SQLException;

    public T copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }
}

