/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.OperatorReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Operator;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class Postgres83OperatorReader
extends OperatorReader {
    protected Postgres83OperatorReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Operator> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        if (!context.containsKey((Object)"id")) {
            context.put("id", null);
        }
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Operator operator = Postgres83OperatorReader.this.createOperator(rs);
                result.add(operator);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("operators83.sql");
    }

    protected Operator createOperator(ExResultSet rs) throws SQLException {
        Operator obj = new Operator(this.getString((ResultSet)rs, "oprname"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setDialect(this.getDialect());
        obj.setId(this.getString((ResultSet)rs, "oid"));
        obj.setLeftArgument(this.getString((ResultSet)rs, "left_type"));
        obj.setRightArgument(this.getString((ResultSet)rs, "right_type"));
        obj.setFunctionSchemaName(this.getString((ResultSet)rs, "code_function_schema"));
        obj.setFunctionName(this.getString((ResultSet)rs, "code_function_name"));
        obj.setRestrictFunctionName(this.getString((ResultSet)rs, "rest_function_name"));
        if (obj.getRestrictFunction() != null) {
            obj.getRestrictFunction().setSchemaName(this.getString((ResultSet)rs, "rest_function_schema"));
        }
        obj.setJoinFunctionName(this.getString((ResultSet)rs, "join_function_name"));
        if (obj.getJoinFunction() != null) {
            obj.getJoinFunction().setSchemaName(this.getString((ResultSet)rs, "join_function_schema"));
        }
        obj.setCommutativeOperatorName(this.getString((ResultSet)rs, "oprcom_name"));
        obj.setNegationOperatorName(this.getString((ResultSet)rs, "oprnegate_name"));
        return obj;
    }
}

