/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresFunctionReader;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.FunctionType;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ParameterDirection;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Postgres84FunctionReader
extends PostgresFunctionReader {
    protected Postgres84FunctionReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected Function createFunction(ExResultSet rs) throws SQLException {
        String function_result;
        Boolean proretset;
        Boolean proiswindow;
        Boolean proisagg;
        Function obj = super.createFunction(rs);
        if (this.getReaderOptions().isReadDefinition()) {
            obj.setDefinition(rs.getString("functiondef"));
        }
        if ((proisagg = this.getBoolean((ResultSet)rs, "proisagg")) != null && proisagg.booleanValue()) {
            obj.setFunctionType(FunctionType.Aggregate);
        }
        if ((proiswindow = this.getBoolean((ResultSet)rs, "proiswindow")) != null && proiswindow.booleanValue()) {
            obj.setFunctionType(FunctionType.Window);
        }
        if ((proretset = this.getBoolean((ResultSet)rs, "proretset")) != null && proretset.booleanValue()) {
            obj.setFunctionType(FunctionType.Table);
        }
        if ((function_result = rs.getString("function_result")) != null && function_result.startsWith("TABLE(")) {
            this.setReturningRecordType(rs, obj);
        }
        return obj;
    }

    @Override
    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache().getString("functions84.sql");
        return node;
    }

    protected void setReturningRecordType(ExResultSet rs, Function obj) throws SQLException {
        String function_result = rs.getString("function_result");
        function_result = function_result.substring(6, function_result.length() - 1);
        String[] args = function_result.split(",");
        obj.getReturning().toTable();
        for (String arg : args) {
            String dataTypeName;
            String name;
            if (CommonUtils.isEmpty((CharSequence)(arg = CommonUtils.trim((String)arg)))) continue;
            int pos = arg.indexOf(32);
            if (pos >= 0) {
                name = CommonUtils.trim((String)arg.substring(0, pos));
                dataTypeName = CommonUtils.trim((String)arg.substring(pos));
            } else {
                name = null;
                dataTypeName = arg;
            }
            obj.getReturning().getTable().getColumns().add(name, c -> c.setDataTypeName(dataTypeName));
        }
        obj.setFunctionType(FunctionType.Table);
    }

    @Override
    protected void setArguments(ExResultSet rs, Function obj) throws SQLException {
        String function_arguments = rs.getString("function_arguments");
        String function_identity_arguments = rs.getString("function_identity_arguments");
        String[] args = function_arguments.split(",");
        String[] argWithoutDefaults = function_identity_arguments.split(",");
        String allArgNames = CommonUtils.unwrap((String)rs.getString("proargnames"), (String)"{", (String)"}");
        String[] argNameArray = CommonUtils.split((String)allArgNames, (String)"[, ]");
        SeparatedStringBuilder builder = new SeparatedStringBuilder(",");
        for (int i = 0; i < args.length; ++i) {
            String arg = argWithoutDefaults[i];
            String argDefault = args[i];
            String defaultValue = this.getDefaultValue(argDefault, arg);
            String argName = null;
            if (!CommonUtils.isEmpty((Object)argNameArray)) {
                argName = CommonUtils.trim((String)argNameArray[i]);
            }
            if (CommonUtils.isEmpty((CharSequence)(arg = CommonUtils.trim((String)arg)))) continue;
            boolean[] variadic = new boolean[]{false};
            ParameterDirection[] diretion = new ParameterDirection[]{ParameterDirection.Input};
            if (arg.startsWith("INOUT")) {
                diretion[0] = ParameterDirection.Inout;
                arg = CommonUtils.trim((String)arg.substring(5));
            } else if (arg.startsWith("OUT")) {
                diretion[0] = ParameterDirection.Output;
                if ((arg = CommonUtils.trim((String)arg.substring(3))).startsWith("VARIADIC")) {
                    arg = CommonUtils.trim((String)arg.substring(8));
                    variadic[0] = true;
                }
            } else if (arg.startsWith("IN ")) {
                arg = CommonUtils.trim((String)arg.substring(3));
            }
            if (!CommonUtils.isEmpty((CharSequence)argName)) {
                arg = CommonUtils.trim((String)arg.substring(argName.length()));
            }
            String dataTypeName = arg;
            obj.getArguments().add(CommonUtils.trim((String)argName), argument -> {
                argument.setDataTypeName(dataTypeName);
                argument.setDirection(diretion[0]);
                argument.setDefaultValue(defaultValue);
                this.setVariadic(variadic[0], (NamedArgument)argument);
                builder.add((Object)(argument.getDataTypeName() != null ? argument.getDataTypeName() : argument.getDataType().toString()));
            });
        }
        obj.setSpecificName(obj.getName() + "(" + builder.toString() + ")");
    }

    private String getDefaultValue(String arg, String argWithoutDefault) {
        if (arg.length() == argWithoutDefault.length()) {
            return null;
        }
        return CommonUtils.trim((String)arg.substring(argWithoutDefault.length()));
    }

    private void setVariadic(boolean variadic, NamedArgument argument) {
        if (variadic) {
            argument.getSpecifics().put("VARIADIC", (Object)variadic);
        }
    }
}

