/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnPair;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FlexList;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class PostgresForeignKeyConstraintReader
extends ForeignKeyConstraintReader {
    public PostgresForeignKeyConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<ForeignKeyConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List list = CommonUtils.list();
        final TripleKeyMap tCMap = CommonUtils.tripleKeyMap();
        final TripleKeyMap tColMap = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Object pk_table_catalog = null;
                String pk_table_schema = this.getString(rs, "constraint_schema");
                String pk_table_name = this.getString(rs, "table_name");
                String pk_columnName = this.getString(rs, "column_name");
                String fk_table_schema = this.getString(rs, "referential_table_schema");
                String fk_table_name = this.getString(rs, "referential_table_name");
                String fk_columnName = this.getString(rs, "referential_column_name");
                String fk_name = this.getString(rs, "constraint_name");
                ForeignKeyConstraint c = (ForeignKeyConstraint)tCMap.get(pk_table_catalog, (Object)pk_table_schema, (Object)fk_name);
                FlexList colList = (FlexList)tColMap.get(pk_table_catalog, (Object)pk_table_schema, (Object)fk_name);
                if (c == null) {
                    c = new ForeignKeyConstraint(fk_name);
                    c.setSchemaName(pk_table_schema);
                    c.setTableName(pk_table_name);
                    c.setUpdateRule(CascadeRule.parse((String)this.getString(rs, "update_rule")));
                    c.setDeleteRule(CascadeRule.parse((String)this.getString(rs, "delete_rule")));
                    c.setDeferrability(Deferrability.getDeferrability((boolean)rs.getBoolean("is_deferrable"), (boolean)rs.getBoolean("initially_deferred")));
                    c.setMatchOption(this.getString(rs, "match_option"));
                    colList = new FlexList();
                    tCMap.put(pk_table_catalog, (Object)pk_table_schema, (Object)fk_name, (Object)c);
                    tColMap.put(pk_table_catalog, (Object)pk_table_schema, (Object)fk_name, (Object)colList);
                    list.add(c);
                }
                ColumnPair cPair = new ColumnPair();
                cPair.refSchemaName = fk_table_schema;
                cPair.refTableName = fk_table_name;
                cPair.refColumnName = fk_columnName;
                cPair.columnName = pk_columnName;
                colList.add((Object)cPair);
            }
        });
        this.setForeignKeyConstraintColumns(tColMap, list);
        return list;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("foreignKeyConstraints.sql");
    }
}

