/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class PostgresUniqueConstraintReader
extends UniqueConstraintReader {
    public PostgresUniqueConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<UniqueConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String constraint_name;
                String table_name;
                String schema_name = this.getString(rs, "constraint_schema");
                UniqueConstraint c = (UniqueConstraint)map.get((Object)schema_name, (Object)(table_name = this.getString(rs, "table_name")), (Object)(constraint_name = this.getString(rs, "constraint_name")));
                if (c == null) {
                    boolean primary = !"unique".equalsIgnoreCase(this.getString(rs, "constraint_type"));
                    c = new UniqueConstraint(constraint_name, primary);
                    c.setSchemaName(schema_name);
                    c.setTableName(table_name);
                    c.setDeferrability(Deferrability.getDeferrability((boolean)rs.getBoolean("is_deferrable"), (boolean)rs.getBoolean("initially_deferred")));
                    result.add(c);
                    map.put((Object)schema_name, (Object)table_name, (Object)constraint_name, (Object)c);
                }
                Column column = new Column(this.getString(rs, "column_name"));
                column.setTableName(table_name);
                c.getColumns().add(column);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("uniqueConstraints.sql");
    }
}

