/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.sql;

import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlBuilder;
import com.sqlapp.data.db.sql.AbstractMergeRowFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.properties.FormulaProperty;
import com.sqlapp.util.CommonUtils;
import java.util.Collection;
import java.util.List;

public class Postgres150MergeRowFactory
extends AbstractMergeRowFactory<PostgresSqlBuilder> {
    protected List<SqlOperation> getOperations(Table table, Collection<Row> rows) {
        List sqlList = CommonUtils.list();
        UniqueConstraint constraint = table.getConstraints().getPrimaryKeyConstraint();
        if (constraint == null) {
            constraint = (UniqueConstraint)CommonUtils.first((List)table.getConstraints().getUniqueConstraints());
        }
        if (constraint == null) {
            for (Row row : rows) {
                sqlList.addAll(super.getOperations(row));
            }
            return sqlList;
        }
        Row firstRow = (Row)CommonUtils.first(rows);
        String targetTable = (String)this.getOptions().getTableOptions().getTemporaryAlias().apply((Object)table);
        PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
        ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.merge()).space()).name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
        this.addTableComment(table, builder);
        builder.lineBreak();
        builder.using();
        builder.lineBreak();
        boolean[] first = new boolean[]{true};
        builder.brackets(() -> {
            builder.indent(() -> {
                for (Row row : rows) {
                    builder.lineBreak();
                    if (row != firstRow) {
                        ((PostgresSqlBuilder)builder.union()).all();
                        builder.lineBreak();
                    }
                    ((PostgresSqlBuilder)builder.select()).space();
                    first[0] = true;
                    for (Column column : table.getColumns()) {
                        String def = this.getValueDefinitionForInsert(row, column);
                        builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                            if (!this.isFormulaColumn((FormulaProperty)column)) {
                                ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.comma(!first[0]))._add(def)).as()).name(column);
                                first[0] = false;
                                this.addSelectColumnComment(column, builder);
                            }
                        });
                    }
                }
            });
            builder.lineBreak();
        });
        ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.lineBreak()).as()).space())._add(targetTable);
        builder.lineBreak();
        builder.on();
        first[0] = true;
        for (Object column : table.getColumns()) {
            if (!constraint.getColumns().contains(column.getName())) continue;
            ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.and(!first[0])).columnName((Column)column, true)).eq()).names(new String[]{targetTable, column.getName()});
            this.addSelectColumnComment((Column)column, builder);
            first[0] = false;
        }
        PostgresSqlBuilder childBuilder = (PostgresSqlBuilder)builder.clone()._clear();
        childBuilder.lineBreak();
        ((PostgresSqlBuilder)((PostgresSqlBuilder)childBuilder.when()).matched()).then();
        childBuilder.appendIndent(1);
        childBuilder.lineBreak();
        ((PostgresSqlBuilder)childBuilder.update()).set();
        first[0] = true;
        for (Column column : table.getColumns()) {
            if (constraint.getColumns().contains(column.getName()) || !this.isUpdateable(column)) continue;
            String def = this.getValueDefinitionForUpdate(firstRow, column);
            if (this.isFormulaColumn((FormulaProperty)column)) continue;
            ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)childBuilder.lineBreak()).comma(!first[0])).name(column)).eq();
            if (this.isOptimisticLockColumn(column)) {
                childBuilder._add(def);
            } else if (this.withCoalesceAtUpdate(column)) {
                childBuilder.coalesce(() -> {
                    ((PostgresSqlBuilder)childBuilder.names(new String[]{column.getName()})).comma();
                    ((PostgresSqlBuilder)childBuilder.names(new String[]{targetTable, column.getName()})).space();
                });
            } else {
                childBuilder.names(new String[]{targetTable, column.getName()});
            }
            this.addUpdateColumnComment(column, builder);
            first[0] = false;
        }
        childBuilder.appendIndent(-1);
        if (!first[0]) {
            builder._merge(childBuilder);
        }
        List insertableColumns = CommonUtils.list();
        builder.lineBreak();
        ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.when()).not()).matched()).then();
        builder.appendIndent(1);
        builder.lineBreak();
        builder.insert();
        ((PostgresSqlBuilder)builder.lineBreak()).brackets(() -> {
            builder.indent(() -> {
                first[0] = true;
                for (Column column : table.getColumns()) {
                    if (!this.isInsertable(column)) continue;
                    String def = this.getValueDefinitionForInsert(firstRow, column);
                    builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                        if (!this.isFormulaColumn((FormulaProperty)column)) {
                            ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.lineBreak()).comma(!first[0])).name(column);
                            this.addInsertColumnComment(column, builder);
                            insertableColumns.add(column);
                            first[0] = false;
                        }
                    });
                }
            });
            builder.lineBreak();
        });
        ((PostgresSqlBuilder)builder.lineBreak()).values();
        ((PostgresSqlBuilder)builder.lineBreak()).brackets(() -> {
            builder.indent(() -> {
                first[0] = true;
                for (Column column : insertableColumns) {
                    String def = this.getValueDefinitionForInsert(firstRow, column);
                    builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                        if (!this.isFormulaColumn((FormulaProperty)column)) {
                            ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.lineBreak()).comma(!first[0])).names(new String[]{targetTable, column.getName()});
                            first[0] = false;
                        }
                    });
                }
            });
            builder.lineBreak();
        });
        builder.appendIndent(-1);
        ((PostgresSqlBuilder)builder.lineBreak()).semicolon();
        this.addSql(sqlList, builder, SqlType.MERGE_ROW, CommonUtils.list(rows));
        return sqlList;
    }
}

