/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.Postgres100ColumnReader;
import com.sqlapp.data.db.dialect.postgres.metadata.Postgres93TableReader;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.node.SqlNode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Postgres100TableReader
extends Postgres93TableReader {
    private static final Pattern LIST_PARTITION_DEF = Pattern.compile("\\s*FOR\\s+VALUES\\s+IN\\s*\\((?<highValue>.*?)\\)\\s*", 2);
    private static final Pattern RANGE_PARTITION_DEF = Pattern.compile("\\s*FOR\\s+VALUES\\s+FROM\\s*\\((?<lowValue>.*?)\\)\\s+TO\\s*\\((?<highValue>.*?)\\)\\s*", 2);
    private static final Pattern PARTITION_COLUMN_DEF = Pattern.compile("\\s*[^(]+\\((?<column>.*)\\)\\s*", 2);

    protected Postgres100TableReader(Dialect dialect) {
        super(dialect);
        this.setRelkind("r", "p");
    }

    @Override
    protected Table createTable(ExResultSet rs) throws SQLException {
        Table table = super.createTable(rs);
        String partStrategy = this.getString((ResultSet)rs, "partition_strategy");
        String partitionExpression = this.getString((ResultSet)rs, "partition_expression");
        String partitionStrategyColumn = this.getString((ResultSet)rs, "partition_strategy_column");
        if (partStrategy != null) {
            table.toPartitioning();
            table.getPartitioning().setPartitioningType(partStrategy);
            Matcher matcher = PARTITION_COLUMN_DEF.matcher(partitionStrategyColumn);
            matcher.matches();
            String column = matcher.group("column");
            table.getPartitioning().getPartitioningColumns().add((AbstractNamedObject)new ReferenceColumn(column));
        }
        if (partitionExpression != null) {
            Table parentTable = new Table(this.getString((ResultSet)rs, "parent_table_name"));
            parentTable.setSchemaName(this.getString((ResultSet)rs, "parent_schema_name"));
            Matcher matcher = RANGE_PARTITION_DEF.matcher(partitionExpression);
            if (matcher.matches()) {
                String lowValue = matcher.group("lowValue");
                String highValue = matcher.group("highValue");
                table.setPartitionParent(parentTable, lowValue, highValue);
            } else {
                matcher = LIST_PARTITION_DEF.matcher(partitionExpression);
                matcher.matches();
                String value = matcher.group("highValue");
                table.setPartitionParent(parentTable, null, value);
            }
        }
        return table;
    }

    @Override
    protected void addInherits(Table table, Table pTable) {
        if (table.getPartitionParent() == null) {
            table.getInherits().add((AbstractNamedObject)pTable);
        }
    }

    @Override
    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("tables100.sql");
    }

    @Override
    protected ColumnReader newColumnReader() {
        return new Postgres100ColumnReader(this.getDialect());
    }
}

