/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.sql;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlBuilder;
import com.sqlapp.data.db.sql.AbstractAlterTableFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Constraint;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.DbObjectPropertyDifference;
import com.sqlapp.data.schemas.Difference;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import java.util.List;
import java.util.Map;

public class PostgresAlterTableFactory
extends AbstractAlterTableFactory<PostgresSqlBuilder> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAddColumn(Table originalTable, Table table, DbObjectDifference diff, List<SqlOperation> result) {
        Column column = (Column)diff.getTarget(Column.class);
        PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
        String _default = column.getDefaultValue();
        boolean notNull = column.isNotNull();
        try {
            if (column.isNotNull()) {
                column.setDefaultValue(null);
                column.setNotNull(false);
            }
            ((PostgresSqlBuilder)builder.alter()).table();
            builder.name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
            ((PostgresSqlBuilder)builder.add()).column();
            builder.name(column);
            ((PostgresSqlBuilder)builder.space()).definitionForAlterColumn(column);
            this.add(result, new SqlOperation[]{this.createOperation(builder.toString(), SqlType.ALTER, null, (DbCommonObject)column)});
            if (notNull) {
                if (_default != null) {
                    builder = (PostgresSqlBuilder)this.createSqlBuilder();
                    ((PostgresSqlBuilder)builder.alter()).table();
                    builder.name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
                    ((PostgresSqlBuilder)builder.alter()).column();
                    builder.name(column);
                    ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.set())._default()).space())._add(_default);
                    this.add(result, new SqlOperation[]{this.createOperation(builder.toString(), SqlType.ALTER, null, (DbCommonObject)column)});
                    builder = (PostgresSqlBuilder)this.createSqlBuilder();
                    ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.update()).space()).name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
                    builder.lineBreak();
                    ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.set()).space()).name(column)).eq()).space())._add(_default);
                    builder.lineBreak();
                    ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.where()).space()).name(column)).is())._null();
                    this.add(result, new SqlOperation[]{this.createOperation(builder.toString(), SqlType.UPDATE, null, (DbCommonObject)column)});
                }
                builder = (PostgresSqlBuilder)this.createSqlBuilder();
                ((PostgresSqlBuilder)builder.alter()).table();
                builder.name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
                ((PostgresSqlBuilder)builder.alter()).column();
                builder.name(column);
                ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.set()).not())._null();
                this.add(result, new SqlOperation[]{this.createOperation(builder.toString(), SqlType.ALTER, null, (DbCommonObject)column)});
            }
        }
        finally {
            column.setDefaultValue(_default);
            column.setNotNull(notNull);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAlterColumn(Table originalTable, Table table, Column oldColumn, Column column, DbObjectDifference diff, List<SqlOperation> result) {
        boolean changeNotNull = diff.getChangedProperties().containsKey(SchemaProperties.NOT_NULL.getLabel());
        boolean changeDefault = diff.getChangedProperties().containsKey(SchemaProperties.DEFAULT_VALUE.getLabel());
        String _default = column.getDefaultValue();
        boolean notNull = column.isNotNull();
        try {
            if (column.isNotNull()) {
                column.setDefaultValue(null);
                column.setNotNull(false);
            }
            PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
            ((PostgresSqlBuilder)builder.alter()).table();
            builder.name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
            builder.alterColumn();
            builder.name(column);
            ((PostgresSqlBuilder)builder.space()).definitionForAlterColumn(column);
            this.add(result, new SqlOperation[]{this.createOperation(builder.toString(), SqlType.ALTER, (DbCommonObject)oldColumn, (DbCommonObject)column)});
            if (changeDefault) {
                builder = (PostgresSqlBuilder)this.createSqlBuilder();
                ((PostgresSqlBuilder)builder.alter()).table();
                builder.name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
                ((PostgresSqlBuilder)builder.alter()).column();
                builder.name(column);
                if (_default != null) {
                    ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.set())._default()).space())._add(_default);
                    this.add(result, new SqlOperation[]{this.createOperation(builder.toString(), SqlType.ALTER, null, (DbCommonObject)column)});
                    if (notNull) {
                        builder = (PostgresSqlBuilder)this.createSqlBuilder();
                        ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.update()).space()).name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
                        builder.lineBreak();
                        ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.set()).space()).name(column)).eq()).space())._add(_default);
                        builder.lineBreak();
                        ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.where()).space()).name(column)).is())._null();
                        this.add(result, new SqlOperation[]{this.createOperation(builder.toString(), SqlType.UPDATE, null, (DbCommonObject)column)});
                    }
                } else {
                    ((PostgresSqlBuilder)builder.drop())._default();
                    this.add(result, new SqlOperation[]{this.createOperation(builder.toString(), SqlType.ALTER, null, (DbCommonObject)column)});
                }
            }
            if (changeNotNull) {
                builder = (PostgresSqlBuilder)this.createSqlBuilder();
                ((PostgresSqlBuilder)builder.alter()).table();
                builder.name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
                ((PostgresSqlBuilder)builder.alter()).column();
                if (notNull) {
                    ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.set()).not())._null();
                    this.add(result, new SqlOperation[]{this.createOperation(builder.toString(), SqlType.ALTER, null, (DbCommonObject)column)});
                } else {
                    ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.drop()).not())._null();
                    this.add(result, new SqlOperation[]{this.createOperation(builder.toString(), SqlType.ALTER, null, (DbCommonObject)column)});
                }
            }
        }
        finally {
            column.setDefaultValue(_default);
            column.setNotNull(notNull);
        }
    }

    protected void addOtherDefinitions(Map<String, Difference<?>> allDiff, Table originalTable, Table table, List<SqlOperation> result) {
        this.addPropertiesDefinitions(allDiff, originalTable, table, result);
        this.addCommentDefinitions(allDiff, originalTable, table, result);
    }

    protected void addPropertiesDefinitions(Map<String, Difference<?>> allDiff, Table originalTable, Table table, List<SqlOperation> result) {
        Difference<?> diff = allDiff.get("oids");
        if (diff != null) {
            PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
            ((PostgresSqlBuilder)builder.alter()).table();
            builder.name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
            Boolean bool = (Boolean)Converters.getDefault().convertObject(diff.getTarget(), Boolean.class);
            if (bool != null && bool.booleanValue()) {
                ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.set()).with()).oids();
            } else {
                ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.set()).without()).oids();
            }
            this.addSql(result, builder, SqlType.ALTER, (DbCommonObject)table);
        }
    }

    protected void addCommentDefinitions(Map<String, Difference<?>> allDiff, Table originalTable, Table table, List<SqlOperation> result) {
        DbObjectDifferenceCollection consDiff;
        DbObjectDifferenceCollection indexDiff;
        DbObjectDifferenceCollection colsDiff;
        Difference<?> tableProp = allDiff.get(SchemaProperties.REMARKS.getLabel());
        if (tableProp != null && tableProp.getState().isChanged()) {
            PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
            ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.comment().on()).table()).space()).name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName())).is()).$if(table.getRemarks() != null, () -> builder.sqlChar(table.getRemarks()), () -> ((PostgresSqlBuilder)builder.is())._null());
            this.addSql(result, builder, SqlType.SET_COMMENT, (DbCommonObject)table);
        }
        if ((colsDiff = (DbObjectDifferenceCollection)allDiff.get(SchemaObjectProperties.COLUMNS.getLabel())) != null) {
            List diffs = colsDiff.findModifiedProperties(this.getDialect(), SchemaProperties.REMARKS.getLabel(), Column.class);
            for (Object diff : diffs) {
                Column obj = (Column)diff.getTarget(Column.class);
                PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
                ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.comment().on()).column()).space()).columnName(obj, true, this.getOptions().isDecorateSchemaName())).is()).$if(obj.getRemarks() != null, () -> builder.sqlChar(obj.getRemarks()), () -> ((PostgresSqlBuilder)builder.is())._null());
                this.addSql(result, builder, SqlType.SET_COMMENT, (DbCommonObject)obj);
            }
        }
        if ((indexDiff = (DbObjectDifferenceCollection)allDiff.get(SchemaObjectProperties.INDEXES.getLabel())) != null) {
            List diffs = indexDiff.findModifiedProperties(this.getDialect(), SchemaProperties.REMARKS.getLabel(), Index.class);
            for (DbObjectPropertyDifference diff : diffs) {
                Index obj = (Index)diff.getTarget(Index.class);
                PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
                ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.comment().on()).index()).space()).name(obj, this.getOptions().isDecorateSchemaName())).is()).$if(obj.getRemarks() != null, () -> builder.sqlChar(obj.getRemarks()), () -> ((PostgresSqlBuilder)builder.is())._null());
                this.addSql(result, builder, SqlType.SET_COMMENT, (DbCommonObject)obj);
            }
        }
        if ((consDiff = (DbObjectDifferenceCollection)allDiff.get(SchemaObjectProperties.CONSTRAINTS.getLabel())) != null) {
            List diffs = consDiff.findModifiedProperties(this.getDialect(), SchemaProperties.REMARKS.getLabel(), Constraint.class);
            for (DbObjectPropertyDifference diff : diffs) {
                Constraint obj = (Constraint)diff.getTarget(Constraint.class);
                PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
                ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.comment().on()).constraint()).space()).name((AbstractSchemaObject)obj, this.getOptions().isDecorateSchemaName())).on()).name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName())).is()).$if(obj.getRemarks() != null, () -> builder.sqlChar(obj.getRemarks()), () -> ((PostgresSqlBuilder)builder.is())._null());
                this.addSql(result, builder, SqlType.SET_COMMENT, (DbCommonObject)obj);
            }
        }
    }
}

