/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005ProcedureArgumentReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.ProcedureReader;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005ProcedureReader
extends ProcedureReader {
    protected SqlServer2005ProcedureReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Procedure> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Procedure obj = SqlServer2005ProcedureReader.this.createProcedure(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("procedures2005.sql");
    }

    protected Procedure createProcedure(ExResultSet rs) throws SQLException {
        Procedure obj = new Procedure(this.getString((ResultSet)rs, "procedure_name"));
        obj.setDialect(this.getDialect());
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setCreatedAt(rs.getTimestamp("create_date"));
        obj.setLastAlteredAt(rs.getTimestamp("modify_date"));
        obj.setClassNamePrefix(this.getString((ResultSet)rs, "assembly_name"));
        obj.setClassName(this.getString((ResultSet)rs, "assembly_class"));
        obj.setMethodName(this.getString((ResultSet)rs, "assembly_method"));
        String definition = this.getString((ResultSet)rs, "definition");
        if (this.getReaderOptions().isReadDefinition()) {
            obj.setDefinition(definition);
        }
        if (this.getReaderOptions().isReadStatement()) {
            obj.setStatement(SqlServerUtils.getProcedureStatement(definition));
        }
        obj.setExecuteAs(this.getString((ResultSet)rs, "execute_as"));
        this.setSpecifics(rs, "assembly_id", (SpecificsProperty)obj);
        return obj;
    }

    protected RoutineArgumentReader<?> newRoutineArgumentReader() {
        return new SqlServer2005ProcedureArgumentReader(this.getDialect());
    }
}

