/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2000UniqueConstraintReader;
import com.sqlapp.data.db.dialect.sqlserver.util.SqlServerIndexOptions;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005UniqueConstraintReader
extends SqlServer2000UniqueConstraintReader {
    protected SqlServer2005UniqueConstraintReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<UniqueConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                boolean includedColumn;
                String name;
                String schema_name;
                String catalog_name = this.getString(rs, "catalog_name");
                UniqueConstraint obj = (UniqueConstraint)map.get((Object)catalog_name, (Object)(schema_name = this.getString(rs, "schema_name")), (Object)(name = this.getString(rs, "constraint_name")));
                if (obj == null) {
                    obj = SqlServer2005UniqueConstraintReader.this.createUniqueConstraint(rs);
                    map.put((Object)catalog_name, (Object)schema_name, (Object)name, (Object)obj);
                }
                String columnName = this.getString(rs, "column_name");
                boolean bl = includedColumn = rs.getInt("is_included_column") == 1;
                if (rs.getInt("is_descending_key") == 1) {
                    obj.getColumns().add(new Column(columnName), Order.Desc).setIncludedColumn(includedColumn);
                } else {
                    obj.getColumns().add(new Column(columnName), Order.Asc).setIncludedColumn(includedColumn);
                }
            }
        });
        return map.toList();
    }

    @Override
    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("uniqueConstraints2005.sql");
    }

    @Override
    protected UniqueConstraint createUniqueConstraint(ExResultSet rs) throws SQLException {
        UniqueConstraint obj = super.createUniqueConstraint(rs);
        for (SqlServerIndexOptions enm : SqlServerIndexOptions.values()) {
            enm.setUniqueConstraint(rs, obj);
        }
        return obj;
    }
}

