/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.metadata.ReaderUtils;
import com.sqlapp.data.schemas.IndexType;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.Routine;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.util.CommonUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlServerUtils
extends ReaderUtils {
    private static final Pattern PROCEDURE_PATTERN1 = Pattern.compile(".*CREATE.*?PROC(EDURE){0,1}.*?\\s+AS(.*)", 42);
    private static final Pattern PROCEDURE_PATTERN2 = Pattern.compile(".*CREATE.*?PROC(EDURE){0,1}.*EXECUTE\\s+AS\\s+[^\\s]+.*?\\s+AS(.*)", 42);
    private static final Pattern FIRST_SPACE_PATTERN = Pattern.compile("[ \\t]*\\n(.*)", 42);
    private static final Pattern FUNCTION_FN_PATTERN1 = Pattern.compile(".*CREATE.*?FUNCTION.*?RETURNS.*?(BEGIN.*END)\\s*", 42);
    private static final Pattern FUNCTION_IF_PATTERN1 = Pattern.compile(".*CREATE.*?FUNCTION.*?RETURNS.*?(RETURN\\s+.*)", 42);
    private static final Pattern FUNCTION_TF_PATTERN1 = Pattern.compile(".*CREATE.*?FUNCTION.*?RETURNS\\s+.*?\\s*(@\\S+).*?TABLE\\s+(.*)", 42);
    private static final Pattern FUNCTION_TF_PATTERN2 = Pattern.compile(".*?(\\(.*\\))\\s+.*(WITH\\s.*?){0,1}(\\s*AS\\s*){0,1}.*?\\s*(BEGIN.*END).*", 42);
    private static final Pattern FUNCTION_FT_PATTERN1 = Pattern.compile(".*CREATE.*?FUNCTION.*?RETURNS\\s+.*?TABLE\\s+.*?(.*)\\s*EXTERNAL\\s+NAME\\s+([\\S]+).*", 42);
    private static final Pattern FUNCTION_FT_PATTERN2 = Pattern.compile("(\\(.*\\))\\s+.*(WITH\\s.*?){0,1}(ORDER\\s+.*?){0,1}(\\s*AS\\s*){0,1}.*", 42);
    private static final Pattern TRIGGER_PATTERN1 = Pattern.compile(".*CREATE.*?TRIGGER.*?AS\\s+(.*)", 42);

    protected static String replaceNames(String definition, String name) {
        return definition.replace("[" + name + "]", name);
    }

    public static IndexType getIndexType(int indexType) {
        if (indexType == 0) {
            return IndexType.BTree;
        }
        if (indexType == 1) {
            return IndexType.Clustered;
        }
        if (indexType == 3) {
            return IndexType.Xml;
        }
        if (indexType == 4) {
            return IndexType.Spatial;
        }
        return IndexType.BTree;
    }

    protected static void setNamedArgument(ResultSet rs, Routine<?> routine, NamedArgument obj) throws SQLException {
        routine.setCatalogName(SqlServerUtils.getString(rs, "catalog_name"));
        routine.setSchemaName(SqlServerUtils.getString(rs, "schema_name"));
        routine.setName(SqlServerUtils.getString(rs, "routine_name"));
        obj.setCatalogName(SqlServerUtils.getString(rs, "catalog_name"));
        obj.setSchemaName(SqlServerUtils.getString(rs, "schema_name"));
        SchemaUtils.setRoutine((NamedArgument)obj, routine);
        String productDataType = SqlServerUtils.getString(rs, "NAME");
        Long maxLength = SqlServerUtils.getLong((ResultSet)rs, (String)"max_length");
        if (maxLength != null && maxLength == -1L) {
            maxLength = "xml".equalsIgnoreCase(productDataType) ? null : Long.valueOf(CommonUtils.LEN_2GB);
        }
        Long precision = SqlServerUtils.getLong((ResultSet)rs, (String)"precision");
        Integer scale = SqlServerUtils.getInteger((ResultSet)rs, (String)"scale");
        obj.setDefaultValue(SqlServerUtils.getString(rs, "default_value"));
        obj.setReadonly(SqlServerUtils.getBoolean((ResultSet)rs, (String)"is_readonly"));
        obj.getDialect().setDbType(productDataType, CommonUtils.notZero((Long[])new Long[]{maxLength, precision}), scale, (DataTypeLengthProperties)obj);
    }

    protected static String getString(ResultSet rs, String name) throws SQLException {
        return SqlServerUtils.rtrim(rs.getNString(name));
    }

    public static String getProcedureStatement(String definition) {
        if (CommonUtils.isEmpty((CharSequence)(definition = SqlServerUtils.rtrim(definition)))) {
            return definition;
        }
        Matcher matcher = PROCEDURE_PATTERN2.matcher(definition);
        String statement = null;
        if (matcher.matches()) {
            statement = SqlServerUtils.trimFirstLine(matcher.group(2));
            return statement;
        }
        matcher = PROCEDURE_PATTERN1.matcher(definition);
        if (matcher.matches()) {
            return SqlServerUtils.trimFirstLine(matcher.group(2));
        }
        return definition;
    }

    private static String rtrim(String definition) {
        definition = CommonUtils.rtrim((String)definition);
        definition = CommonUtils.rtrim((String)definition, (char[])new char[]{';'});
        definition = CommonUtils.rtrim((String)definition);
        return definition;
    }

    private static String trimFirstLine(String statement) {
        Matcher matcher = FIRST_SPACE_PATTERN.matcher(statement);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return statement;
    }

    public static String getFunctionStatement(String definition, String type) {
        if (definition == null) {
            return definition;
        }
        if ("FN".equalsIgnoreCase(type)) {
            return SqlServerUtils.getFunctionStatementFN(definition);
        }
        if ("IF".equalsIgnoreCase(type)) {
            return SqlServerUtils.getFunctionStatementIF(definition);
        }
        if ("TF".equalsIgnoreCase(type)) {
            return SqlServerUtils.getFunctionStatementTF(definition);
        }
        return definition;
    }

    protected static String getFunctionStatementFN(String definition) {
        definition = SqlServerUtils.rtrim(definition);
        Matcher matcher = FUNCTION_FN_PATTERN1.matcher(definition);
        String statement = null;
        if (matcher.matches()) {
            statement = matcher.group(1);
            statement = SqlServerUtils.trimFirstLine(statement);
            return statement;
        }
        return definition;
    }

    protected static String getFunctionStatementIF(String definition) {
        definition = SqlServerUtils.rtrim(definition);
        Matcher matcher = FUNCTION_IF_PATTERN1.matcher(definition);
        String statement = null;
        if (matcher.matches()) {
            statement = SqlServerUtils.trimFirstLine(matcher.group(1));
            return statement;
        }
        return definition;
    }

    protected static String getFunctionStatementTF(String definition) {
        definition = SqlServerUtils.rtrim(definition);
        Matcher matcher = FUNCTION_TF_PATTERN1.matcher(definition);
        String statement = null;
        if (!matcher.matches()) {
            return definition;
        }
        statement = matcher.group(2);
        if (!(matcher = FUNCTION_TF_PATTERN2.matcher(statement)).matches()) {
            return statement;
        }
        statement = matcher.group(4);
        return statement;
    }

    public static String getFunctionReturnName(String definition) {
        if ((definition = SqlServerUtils.rtrim(definition)) == null) {
            return null;
        }
        Matcher matcher = FUNCTION_TF_PATTERN1.matcher(definition);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    public static String getFunctionReturnTable(String definition) {
        definition = SqlServerUtils.rtrim(definition);
        Matcher matcher = FUNCTION_FT_PATTERN1.matcher(definition);
        String statement = null;
        if (matcher.matches()) {
            String group = matcher.group(1);
            if ((matcher = FUNCTION_FT_PATTERN2.matcher(group)).matches()) {
                statement = matcher.group(1);
                return statement;
            }
            return null;
        }
        matcher = FUNCTION_TF_PATTERN1.matcher(definition);
        if (!matcher.matches()) {
            return null;
        }
        statement = matcher.group(2);
        if (!(matcher = FUNCTION_TF_PATTERN2.matcher(statement)).matches()) {
            return statement;
        }
        statement = matcher.group(1);
        return statement;
    }

    public static String getTriggerStatement(String definition) {
        if (definition == null) {
            return null;
        }
        Matcher matcher = TRIGGER_PATTERN1.matcher(definition = SqlServerUtils.rtrim(definition));
        if (matcher.matches()) {
            String group = matcher.group(1);
            return group;
        }
        return definition;
    }

    public static Long getMaxLength(String productDataType, Long byteLength) {
        if (((productDataType = productDataType.toUpperCase()).startsWith("NTEXT") || productDataType.startsWith("NCHAR") || productDataType.startsWith("NVARCHAR") && byteLength != null) && byteLength > 0L) {
            return byteLength / 2L;
        }
        return byteLength;
    }
}

