/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.PublicDbLinkReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.PublicDbLink;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class SqlServer2000PublicDbLinkReader
extends PublicDbLinkReader {
    protected SqlServer2000PublicDbLinkReader(Dialect dialect) {
        super(dialect);
    }

    protected List<PublicDbLink> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                PublicDbLink obj = SqlServer2000PublicDbLinkReader.this.createDbLink(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("publicDbLinks2000.sql");
    }

    protected PublicDbLink createDbLink(ExResultSet rs) throws SQLException {
        String name = this.getString((ResultSet)rs, "name");
        String connection_catalog = this.getString((ResultSet)rs, "catalog");
        String userName = this.getString((ResultSet)rs, "user_name");
        String data_source = this.getString((ResultSet)rs, "data_source");
        Timestamp modifyDate = rs.getTimestamp("modify_date");
        PublicDbLink obj = new PublicDbLink(name);
        obj.setUserId(userName);
        obj.setDataSource(data_source);
        obj.setConnectionCatalog(connection_catalog);
        obj.setLastAlteredAt(modifyDate);
        this.setSpecifics((ResultSet)rs, "provider_string", (SpecificsProperty)obj);
        return obj;
    }
}

