/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2000ColumnReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005ColumnReader
extends SqlServer2000ColumnReader {
    protected SqlServer2005ColumnReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Column> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Column column = SqlServer2005ColumnReader.this.createColumn(rs);
                result.add(column);
            }
        });
        return result;
    }

    @Override
    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("columns2005.sql");
    }

    @Override
    protected Column createColumn(ExResultSet rs) throws SQLException {
        Boolean identityInsert;
        Column column = super.createColumn(rs);
        String check_definition = CommonUtils.replace((String)CommonUtils.trim((String)CommonUtils.unwrap((String)this.getString((ResultSet)rs, "check_definition"), (char)'(', (char)')')), (String)("[" + column.getName() + "]"), (String)column.getName());
        String check_constraint_name = this.getString((ResultSet)rs, "check_constraint_name");
        if (!CommonUtils.isEmpty((CharSequence)check_definition)) {
            CheckConstraint checkConstraint = new CheckConstraint(check_constraint_name, check_definition, new Column[]{column});
            column.setCheckConstraint(checkConstraint);
        }
        if ((identityInsert = this.getBoolean((ResultSet)rs, "is_not_for_replication")) != null && identityInsert.booleanValue()) {
            this.setSpecifics((ResultSet)rs, "is_not_for_replication", (SpecificsProperty)column);
        }
        this.setSpecifics((ResultSet)rs, "xmlschema", (SpecificsProperty)column);
        return column;
    }
}

