/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.sql;

import com.sqlapp.data.db.dialect.sqlserver.util.SqlServerSqlBuilder;
import com.sqlapp.data.db.sql.AbstractMergeByPkTableFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.properties.FormulaProperty;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public class SqlServer2008MergeByPkTableFactory
extends AbstractMergeByPkTableFactory<SqlServerSqlBuilder> {
    public List<SqlOperation> createSql(Table table) {
        List sqlList = CommonUtils.list();
        UniqueConstraint constraint = this.getUniqueConstraint(table);
        if (constraint == null) {
            return super.createSql(table);
        }
        String targetTable = (String)this.getOptions().getTableOptions().getTemporaryAlias().apply((Object)table);
        SqlServerSqlBuilder builder = (SqlServerSqlBuilder)this.createSqlBuilder();
        ((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.merge()).space()).name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
        builder.lineBreak();
        boolean[] first = new boolean[]{true};
        builder.using();
        ((SqlServerSqlBuilder)builder.lineBreak()).brackets(() -> {
            builder.indent(() -> {
                builder.lineBreak();
                ((SqlServerSqlBuilder)builder.select()).space();
                for (Column column : table.getColumns()) {
                    String def;
                    if (this.isFormulaColumn((FormulaProperty)column)) continue;
                    if (this.isAutoIncrementColumn(column)) {
                        def = this.getValueDefinitionSimple(column);
                        builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                            builder.lineBreak();
                            ((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.comma(!first[0]))._add(def)).as()).name(column);
                            first[0] = false;
                        });
                        continue;
                    }
                    def = this.getValueDefinitionForInsert(column);
                    builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                        builder.lineBreak();
                        ((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.comma(!first[0]))._add(def)).as()).name(column);
                        first[0] = false;
                    });
                }
            });
            builder.lineBreak();
        });
        ((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.as()).space())._add(targetTable);
        builder.lineBreak();
        builder.on();
        first[0] = true;
        for (Column column : table.getColumns()) {
            if (!constraint.getColumns().contains(column.getName())) continue;
            ((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.and(!first[0])).columnName(column, true)).eq()).names(new String[]{targetTable, column.getName()});
            first[0] = false;
        }
        builder.lineBreak();
        ((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.when()).matched()).then();
        builder.indent(() -> {
            builder.lineBreak();
            ((SqlServerSqlBuilder)builder.update()).set();
            first[0] = true;
            builder.indent(() -> {
                for (Column column : table.getColumns()) {
                    if (constraint.getColumns().contains(column.getName()) || !this.isUpdateable(column) || this.isFormulaColumn((FormulaProperty)column)) continue;
                    String def = this.getValueDefinitionForUpdate(column);
                    ((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.lineBreak()).comma(!first[0])).name(column)).eq();
                    if (this.isOptimisticLockColumn(column)) {
                        builder._add(def);
                    } else if (this.withCoalesceAtUpdate(column)) {
                        ((SqlServerSqlBuilder)builder.coalesce())._add('(', () -> {
                            ((SqlServerSqlBuilder)builder.names(new String[]{column.getName()})).comma();
                            ((SqlServerSqlBuilder)builder.names(new String[]{targetTable, column.getName()})).space();
                        }, ')');
                    } else {
                        builder.names(new String[]{targetTable, column.getName()});
                    }
                    first[0] = false;
                }
            });
        });
        builder.lineBreak();
        ((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)builder.when()).not()).matched()).then();
        builder.indent(() -> {
            List insertableColumns = CommonUtils.list();
            builder.lineBreak();
            builder.insert();
            builder.lineBreak();
            builder.brackets(() -> {
                first[0] = true;
                builder.indent(() -> {
                    for (Column column : table.getColumns()) {
                        if (!this.isInsertable(column)) continue;
                        String def = this.getValueDefinitionForInsert(column);
                        builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                            if (!this.isFormulaColumn((FormulaProperty)column)) {
                                builder.lineBreak();
                                ((SqlServerSqlBuilder)builder.comma(!first[0])).name(column);
                                insertableColumns.add(column);
                                first[0] = false;
                            }
                        });
                    }
                });
                builder.lineBreak();
            });
            ((SqlServerSqlBuilder)builder.lineBreak()).values();
            builder.lineBreak();
            builder.brackets(() -> {
                first[0] = true;
                builder.indent(() -> {
                    for (Column column : insertableColumns) {
                        builder.lineBreak();
                        String def = this.getValueDefinitionForInsert(column);
                        builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                            if (!this.isFormulaColumn((FormulaProperty)column)) {
                                ((SqlServerSqlBuilder)builder.comma(!first[0])).names(new String[]{targetTable, column.getName()});
                                first[0] = false;
                            }
                        });
                    }
                });
                builder.lineBreak();
            });
        });
        this.addSql(sqlList, builder, SqlType.MERGE_BY_PK, (DbCommonObject)table);
        return sqlList;
    }

    private UniqueConstraint getUniqueConstraint(Table table) {
        UniqueConstraint constraint = table.getConstraints().getPrimaryKeyConstraint();
        if (constraint == null) {
            constraint = (UniqueConstraint)CommonUtils.first((List)table.getConstraints().getUniqueConstraints());
        }
        return constraint;
    }
}

