/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.log.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.StackifyError;
import com.stackify.api.WebRequestDetail;
import com.stackify.api.common.lang.Throwables;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.ServletLogContext;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class ILoggingEventAdapter
implements EventAdapter<ILoggingEvent> {
    private final EnvironmentDetail envDetail;
    private final ObjectMapper json = new ObjectMapper();

    public ILoggingEventAdapter(EnvironmentDetail envDetail) {
        Preconditions.checkNotNull((Object)envDetail);
        this.envDetail = envDetail;
    }

    public Optional<Throwable> getThrowable(ILoggingEvent event) {
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null && iThrowableProxy instanceof ThrowableProxy) {
            ThrowableProxy throwableProxy = (ThrowableProxy)iThrowableProxy;
            return Optional.fromNullable((Object)throwableProxy.getThrowable());
        }
        return Optional.absent();
    }

    public StackifyError getStackifyError(ILoggingEvent event, Throwable exception) {
        Optional webRequest;
        StackifyError.Builder builder = StackifyError.newBuilder();
        builder.environmentDetail(this.envDetail);
        builder.occurredEpochMillis(new Date(event.getTimeStamp()));
        if (exception != null) {
            builder.error(Throwables.toErrorItem((String)event.getFormattedMessage(), (Throwable)exception));
        } else {
            StackTraceElement locInfo;
            String className = null;
            String methodName = null;
            int lineNumber = 0;
            StackTraceElement[] callerData = event.getCallerData();
            if (callerData != null && (locInfo = callerData[0]) != null) {
                className = locInfo.getClassName();
                methodName = locInfo.getMethodName();
                lineNumber = locInfo.getLineNumber();
            }
            builder.error(Throwables.toErrorItem((String)event.getFormattedMessage(), className, methodName, (int)lineNumber));
        }
        Optional user = ServletLogContext.getUser();
        if (user.isPresent()) {
            builder.userName((String)user.get());
        }
        if ((webRequest = ServletLogContext.getWebRequest()).isPresent()) {
            builder.webRequestDetail((WebRequestDetail)webRequest.get());
        }
        builder.serverVariables((Map)Maps.fromProperties((Properties)System.getProperties()));
        return builder.build();
    }

    public LogMsg getLogMsg(ILoggingEvent event, Optional<StackifyError> error) {
        StackTraceElement locInfo;
        StackTraceElement[] callerData;
        LogMsg.Builder builder = LogMsg.newBuilder();
        builder.msg(event.getFormattedMessage());
        Map props = event.getMDCPropertyMap();
        if (props != null && !props.isEmpty()) {
            try {
                builder.data(this.json.writeValueAsString((Object)props));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        builder.ex((StackifyError)error.orNull());
        builder.th(event.getThreadName());
        builder.epochMs(Long.valueOf(event.getTimeStamp()));
        builder.level(event.getLevel().toString().toLowerCase());
        Optional transactionId = ServletLogContext.getTransactionId();
        if (transactionId.isPresent()) {
            builder.transId((String)transactionId.get());
        }
        if ((callerData = event.getCallerData()) != null && (locInfo = callerData[0]) != null) {
            builder.srcMethod(locInfo.getClassName() + "." + locInfo.getMethodName());
            try {
                builder.srcLine(Integer.valueOf(locInfo.getLineNumber()));
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public boolean isErrorLevel(ILoggingEvent event) {
        return event.getLevel() == Level.ERROR;
    }
}

