/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.log.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.StackifyError;
import com.stackify.api.common.lang.Throwables;
import com.stackify.api.common.log.EventAdapter;
import java.util.Date;
import java.util.Map;

public class ILoggingEventAdapter
implements EventAdapter<ILoggingEvent> {
    private final EnvironmentDetail envDetail;

    public ILoggingEventAdapter(EnvironmentDetail envDetail) {
        Preconditions.checkNotNull((Object)envDetail);
        this.envDetail = envDetail;
    }

    public Optional<Throwable> getThrowable(ILoggingEvent event) {
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null && iThrowableProxy instanceof ThrowableProxy) {
            ThrowableProxy throwableProxy = (ThrowableProxy)iThrowableProxy;
            return Optional.fromNullable((Object)throwableProxy.getThrowable());
        }
        return Optional.absent();
    }

    public StackifyError getStackifyError(ILoggingEvent event, Throwable exception) {
        StackifyError.Builder builder = StackifyError.newBuilder();
        builder.environmentDetail(this.envDetail);
        builder.occurredEpochMillis(new Date(event.getTimeStamp()));
        builder.error(Throwables.toErrorItem((String)event.getFormattedMessage(), (Throwable)exception));
        return builder.build();
    }

    public LogMsg getLogMsg(ILoggingEvent event, Optional<StackifyError> error) {
        StackTraceElement locInfo;
        LogMsg.Builder builder = LogMsg.newBuilder();
        builder.msg(event.getFormattedMessage());
        Map props = event.getMDCPropertyMap();
        if (props != null && !props.isEmpty()) {
            builder.data(props.toString());
        }
        builder.ex((StackifyError)error.orNull());
        builder.th(event.getThreadName());
        builder.epochMs(Long.valueOf(event.getTimeStamp()));
        builder.level(event.getLevel().toString().toLowerCase());
        StackTraceElement[] callerData = event.getCallerData();
        if (callerData != null && (locInfo = callerData[0]) != null) {
            builder.srcMethod(locInfo.getMethodName());
            try {
                builder.srcLine(Integer.valueOf(locInfo.getLineNumber()));
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return builder.build();
    }
}

