/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.log.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.StackifyError;
import com.stackify.api.WebRequestDetail;
import com.stackify.api.common.lang.Throwables;
import com.stackify.api.common.log.APMLogData;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.ServletLogContext;
import com.stackify.api.common.util.Maps;
import com.stackify.api.common.util.Preconditions;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class ILoggingEventAdapter
implements EventAdapter<ILoggingEvent> {
    private final EnvironmentDetail envDetail;
    private final ObjectMapper json = new ObjectMapper();

    public ILoggingEventAdapter(EnvironmentDetail envDetail) {
        Preconditions.checkNotNull((Object)envDetail);
        this.envDetail = envDetail;
    }

    public Throwable getThrowable(ILoggingEvent event) {
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null && iThrowableProxy instanceof ThrowableProxy) {
            ThrowableProxy throwableProxy = (ThrowableProxy)iThrowableProxy;
            return throwableProxy.getThrowable();
        }
        return null;
    }

    public StackifyError getStackifyError(ILoggingEvent event, Throwable exception) {
        WebRequestDetail webRequest;
        String user;
        StackifyError.Builder builder = StackifyError.newBuilder();
        builder.environmentDetail(this.envDetail);
        builder.occurredEpochMillis(new Date(event.getTimeStamp()));
        if (exception != null) {
            builder.error(Throwables.toErrorItem((String)event.getFormattedMessage(), (Throwable)exception));
        } else {
            StackTraceElement locInfo;
            String className = null;
            String methodName = null;
            int lineNumber = 0;
            StackTraceElement[] callerData = event.getCallerData();
            if (callerData != null && 0 < callerData.length && (locInfo = callerData[0]) != null) {
                className = locInfo.getClassName();
                methodName = locInfo.getMethodName();
                lineNumber = locInfo.getLineNumber();
            }
            builder.error(Throwables.toErrorItem((String)event.getFormattedMessage(), className, methodName, (int)lineNumber));
        }
        String string = user = APMLogData.isLinked() ? APMLogData.getUser() : ServletLogContext.getUser();
        if (user != null) {
            builder.userName(user);
        }
        WebRequestDetail webRequestDetail = webRequest = APMLogData.isLinked() ? APMLogData.getWebRequest() : ServletLogContext.getWebRequest();
        if (webRequest != null) {
            builder.webRequestDetail(webRequest);
        }
        builder.serverVariables(Maps.fromProperties((Properties)System.getProperties()));
        return builder.build();
    }

    public LogMsg getLogMsg(ILoggingEvent event, StackifyError error) {
        StackTraceElement locInfo;
        StackTraceElement[] callerData;
        String transactionId;
        LogMsg.Builder builder = LogMsg.newBuilder();
        builder.msg(event.getFormattedMessage());
        Map props = event.getMDCPropertyMap();
        if (props != null && !props.isEmpty()) {
            try {
                builder.data(this.json.writeValueAsString((Object)props));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        builder.ex(error);
        builder.th(event.getThreadName());
        builder.epochMs(Long.valueOf(event.getTimeStamp()));
        builder.level(event.getLevel().toString().toLowerCase());
        String string = transactionId = APMLogData.isLinked() ? APMLogData.getTransactionId() : ServletLogContext.getTransactionId();
        if (transactionId != null) {
            builder.transId(transactionId);
        }
        if ((callerData = event.getCallerData()) != null && 0 < callerData.length && (locInfo = callerData[0]) != null) {
            builder.srcMethod(locInfo.getClassName() + "." + locInfo.getMethodName());
            try {
                builder.srcLine(Integer.valueOf(locInfo.getLineNumber()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public boolean isErrorLevel(ILoggingEvent event) {
        return event.getLevel().isGreaterOrEqual(Level.ERROR);
    }

    public String getClassName(ILoggingEvent event) {
        StackTraceElement locInfo;
        StackTraceElement[] callerData = event.getCallerData();
        if (callerData != null && 0 < callerData.length && (locInfo = callerData[0]) != null) {
            return locInfo.getClassName();
        }
        return null;
    }
}

