/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.log.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.stackify.api.common.ApiClients;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.ApiConfigurations;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.LogAppender;
import com.stackify.api.common.mask.Masker;
import com.stackify.log.logback.ILoggingEventAdapter;

public class StackifyLogAppender
extends AppenderBase<ILoggingEvent> {
    private String apiUrl = "https://api.stackify.com";
    private String apiKey = null;
    private String application = null;
    private String environment = null;
    private String skipJson = "false";
    private String maskEnabled;
    private String maskCreditCard;
    private String maskSSN;
    private String maskIP;
    private String maskCustom;
    private String allowComDotStackify = null;
    private LogAppender<ILoggingEvent> logAppender;

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void start() {
        super.start();
        ApiConfiguration apiConfig = ApiConfigurations.fromPropertiesWithOverrides((String)this.apiUrl, (String)this.apiKey, (String)this.application, (String)this.environment, (String)this.allowComDotStackify);
        String clientName = ApiClients.getApiClient(StackifyLogAppender.class, (String)"/stackify-log-logback.properties", (String)"stackify-log-logback");
        try {
            Masker masker = new Masker();
            if (Boolean.parseBoolean(this.maskEnabled)) {
                masker.addMask("CREDITCARD");
                masker.addMask("SSN");
                if (this.maskCreditCard != null && !Boolean.parseBoolean(this.maskCreditCard)) {
                    masker.removeMask("CREDITCARD");
                }
                if (this.maskSSN != null && !Boolean.parseBoolean(this.maskSSN)) {
                    masker.removeMask("SSN");
                }
                if (Boolean.parseBoolean(this.maskIP)) {
                    masker.addMask("IP");
                }
                if (this.maskCustom != null) {
                    masker.addMask(this.maskCustom);
                }
            } else {
                masker.clearMasks();
            }
            this.logAppender = new LogAppender(clientName, (EventAdapter)new ILoggingEventAdapter(apiConfig.getEnvDetail()), masker, Boolean.parseBoolean(this.skipJson));
            this.logAppender.activate(apiConfig);
        }
        catch (Exception e) {
            this.addError("Exception starting the Stackify_LogBackgroundService", e);
        }
    }

    protected void append(ILoggingEvent event) {
        try {
            this.logAppender.append((Object)event);
        }
        catch (Exception e) {
            this.addError("Exception appending event to Stackify Log Appender", e);
        }
    }

    public void stop() {
        try {
            this.logAppender.close();
        }
        catch (Exception e) {
            this.addError("Exception closing Stackify Log Appender", e);
        }
        super.stop();
    }

    public void setSkipJson(String skipJson) {
        this.skipJson = skipJson;
    }

    public String getSkipJson() {
        return this.skipJson;
    }

    public void setMaskEnabled(String maskEnabled) {
        this.maskEnabled = maskEnabled;
    }

    public String getMaskEnabled() {
        return this.maskEnabled;
    }

    public void setMaskCreditCard(String maskCreditCard) {
        this.maskCreditCard = maskCreditCard;
    }

    public String getMaskCreditCard() {
        return this.maskCreditCard;
    }

    public void setMaskSSN(String maskSSN) {
        this.maskSSN = maskSSN;
    }

    public String getMaskSSN() {
        return this.maskSSN;
    }

    public void setMaskIP(String maskIP) {
        this.maskIP = maskIP;
    }

    public String getMaskIP() {
        return this.maskIP;
    }

    public void setMaskCustom(String maskCustom) {
        this.maskCustom = maskCustom;
    }

    public String getMaskCustom() {
        return this.maskCustom;
    }

    public void setAllowComDotStackify(String allowComDotStackify) {
        this.allowComDotStackify = allowComDotStackify;
    }

    public String getAllowComDotStackify() {
        return this.allowComDotStackify;
    }
}

