/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.net;

import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.net.HttpRedirectStrategy;
import java.io.IOException;
import java.net.URI;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpHelper {
    private static final int CONN_TIMEOUT = 20000;
    private static final String DEFAULT_CONTENT_TYPE_FMT = "application/vnd.stackmob+json; version=%d";
    private static String DEFAULT_CONTENT_TYPE;
    private static DefaultHttpClient mHttpClient;
    private static OAuthConsumer mConsumer;

    private static synchronized void ensureHttpClient(String sessionKey, String sessionSecret, StackMobRedirectedCallback redirCB) {
        if (mHttpClient == null) {
            mHttpClient = HttpHelper.setupHttpClient(sessionKey, sessionSecret, redirCB);
        }
    }

    public static String doGet(URI uri, String sessionKey, String sessionSecret, StackMobRedirectedCallback redirCB) throws StackMobException {
        HttpHelper.ensureHttpClient(sessionKey, sessionSecret, redirCB);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        HttpGet request = new HttpGet(uri);
        request.setHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        request.setHeader("Accept", DEFAULT_CONTENT_TYPE);
        try {
            mConsumer.sign((Object)request);
            return (String)mHttpClient.execute((HttpUriRequest)request, (ResponseHandler)responseHandler);
        }
        catch (OAuthMessageSignerException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (OAuthExpectationFailedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (OAuthCommunicationException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ClientProtocolException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (IOException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    public static String doPost(URI uri, HttpEntity entity, String sessionKey, String sessionSecret, StackMobRedirectedCallback redirCB) throws StackMobException {
        HttpHelper.ensureHttpClient(sessionKey, sessionSecret, redirCB);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        HttpPost request = new HttpPost(uri);
        if (null != entity) {
            request.setEntity(entity);
        }
        request.setHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        request.setHeader("Accept", DEFAULT_CONTENT_TYPE);
        try {
            mConsumer.sign((Object)request);
            return (String)mHttpClient.execute((HttpUriRequest)request, (ResponseHandler)responseHandler);
        }
        catch (OAuthMessageSignerException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (OAuthExpectationFailedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (OAuthCommunicationException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ClientProtocolException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (IOException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    public static String doPut(URI uri, HttpEntity entity, String sessionKey, String sessionSecret, StackMobRedirectedCallback redirCB) throws StackMobException {
        HttpHelper.ensureHttpClient(sessionKey, sessionSecret, redirCB);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        HttpPut request = new HttpPut(uri);
        if (null != entity) {
            request.setEntity(entity);
        }
        request.setHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        request.setHeader("Accept", DEFAULT_CONTENT_TYPE);
        try {
            mConsumer.sign((Object)request);
            return (String)mHttpClient.execute((HttpUriRequest)request, (ResponseHandler)responseHandler);
        }
        catch (OAuthMessageSignerException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (OAuthExpectationFailedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (OAuthCommunicationException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ClientProtocolException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (IOException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    public static String doDelete(URI uri, String sessionKey, String sessionSecret, StackMobRedirectedCallback redirCB) throws StackMobException {
        HttpHelper.ensureHttpClient(sessionKey, sessionSecret, redirCB);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        HttpDelete request = new HttpDelete(uri);
        request.setHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        request.setHeader("Accept", DEFAULT_CONTENT_TYPE);
        try {
            mConsumer.sign((Object)request);
            return (String)mHttpClient.execute((HttpUriRequest)request, (ResponseHandler)responseHandler);
        }
        catch (OAuthMessageSignerException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (OAuthExpectationFailedException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (OAuthCommunicationException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (ClientProtocolException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (IOException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    private static DefaultHttpClient setupHttpClient(String sessionKey, String sessionSecret, StackMobRedirectedCallback redirCB) {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpHelper.setConnectionParams((HttpParams)httpParams);
        SchemeRegistry schemeRegistry = HttpHelper.registerFactories();
        ThreadSafeClientConnManager clientConnectionManager = new ThreadSafeClientConnManager(schemeRegistry);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)clientConnectionManager, (HttpParams)httpParams);
        client.setRedirectStrategy((RedirectStrategy)new HttpRedirectStrategy(redirCB));
        mConsumer = new CommonsHttpOAuthConsumer(sessionKey, sessionSecret);
        return client;
    }

    public static void setVersion(int version) {
        DEFAULT_CONTENT_TYPE = String.format(DEFAULT_CONTENT_TYPE_FMT, version);
    }

    private static SchemeRegistry registerFactories() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        return schemeRegistry;
    }

    private static void setConnectionParams(HttpParams httpParams) {
        HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)httpParams, (String)"UTF-8");
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)20000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)20000);
    }
}

