/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.util;

import com.stackmob.sdk.model.StackMobModel;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public enum SerializationMetadata {
    PRIMITIVE,
    OBJECT,
    MODEL,
    PRIMITIVE_ARRAY,
    OBJECT_ARRAY,
    MODEL_ARRAY;

    private static Map<Class<?>, Map<String, SerializationMetadata>> metadataForClasses;
    private static Map<Class<?>, Map<String, String>> jsonNamesForClasses;

    public static SerializationMetadata getSerializationMetadata(Class<?> actualClass, String fieldName) {
        SerializationMetadata.ensureMetadata(actualClass);
        return metadataForClasses.get(actualClass).get(fieldName);
    }

    public static String getFieldNameFromJsonName(Class<?> actualClass, String jsonName) {
        SerializationMetadata.ensureMetadata(actualClass);
        return jsonNamesForClasses.get(actualClass).get(jsonName);
    }

    public static synchronized void ensureMetadata(Class<?> actualClass) {
        if (!metadataForClasses.containsKey(actualClass)) {
            metadataForClasses.put(actualClass, new HashMap());
            jsonNamesForClasses.put(actualClass, new HashMap());
            Class<?> currentClass = actualClass;
            while (!currentClass.equals(StackMobModel.class)) {
                for (Field field : currentClass.getDeclaredFields()) {
                    jsonNamesForClasses.get(actualClass).put(field.getName().toLowerCase(), field.getName());
                    metadataForClasses.get(actualClass).put(field.getName(), SerializationMetadata.determineMetadata(field));
                }
                currentClass = currentClass.getSuperclass();
            }
        }
    }

    private static SerializationMetadata determineMetadata(Field field) {
        if (SerializationMetadata.isArray(field.getType())) {
            Class<?> componentClass = SerializationMetadata.getComponentClass(field);
            if (SerializationMetadata.isPrimitive(componentClass)) {
                return PRIMITIVE_ARRAY;
            }
            if (SerializationMetadata.isModel(componentClass)) {
                return MODEL_ARRAY;
            }
            return OBJECT_ARRAY;
        }
        if (SerializationMetadata.isPrimitive(field.getType())) {
            return PRIMITIVE;
        }
        if (SerializationMetadata.isModel(field.getType())) {
            return MODEL;
        }
        return OBJECT;
    }

    private static boolean isArray(Class<?> aClass) {
        return aClass.isArray() || Collection.class.isAssignableFrom(aClass);
    }

    public static Class<?> getComponentClass(Field field) {
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type componentType = pType.getActualTypeArguments()[0];
            if (componentType instanceof Class) {
                return (Class)componentType;
            }
            if (componentType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)componentType).getRawType();
            }
        }
        return null;
    }

    private static boolean isPrimitive(Class<?> aClass) {
        return aClass.isPrimitive() || aClass.equals(String.class);
    }

    private static boolean isModel(Class<?> aClass) {
        return StackMobModel.class.isAssignableFrom(aClass);
    }

    static {
        metadataForClasses = new HashMap();
        jsonNamesForClasses = new HashMap();
    }
}

