/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.util;

import com.stackmob.sdk.util.Pair;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.scribe.model.Response;

public class StackMobCookieManager {
    protected static final String SetCookieHeaderKey = "Set-Cookie";
    protected static final String EXPIRES = "Expires";
    protected static final String SESSION_PREFIX = "session_";
    protected final ConcurrentHashMap<String, Map.Entry<String, Date>> cookies = new ConcurrentHashMap();

    public Map<String, Map.Entry<String, Date>> getCookies() {
        return this.cookies;
    }

    public Map.Entry<String, Date> getSessionCookie() {
        for (String cookieName : this.cookies.keySet()) {
            if (!cookieName.startsWith(SESSION_PREFIX)) continue;
            return this.cookies.get(cookieName);
        }
        return null;
    }

    public void storeCookies(Response resp) {
        this.storeCookie((String)resp.getHeaders().get(SetCookieHeaderKey));
    }

    protected void storeCookie(String cookieString) {
        this.addToCookieMap(this.cookies, cookieString);
    }

    protected void addToCookieMap(Map<String, Map.Entry<String, Date>> map, String cookieString) {
        if (cookieString != null) {
            String[] sessionSplit;
            String session = null;
            String expires = null;
            for (String cookie : cookieString.split(";")) {
                if (cookie.startsWith(SESSION_PREFIX)) {
                    session = cookie;
                }
                if (!cookie.startsWith(EXPIRES)) continue;
                expires = cookie;
            }
            if (session != null && (sessionSplit = session.split("=")).length == 2) {
                String[] expiresSplit;
                Date expiryDate = null;
                if (expires != null && (expiresSplit = expires.split("=")).length == 2) {
                    try {
                        expiryDate = new SimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z").parse(expiresSplit[1]);
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                map.put(sessionSplit[0], new Pair<String, Object>(sessionSplit[1], expiryDate));
            }
        }
    }

    protected String cookieMapToHeaderString(Map<String, Map.Entry<String, Date>> map) {
        StringBuilder cookieBuilder = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Map.Entry<String, Date>> c : this.cookies.entrySet()) {
            if (!this.isUnexpired(c.getValue())) continue;
            if (!first) {
                cookieBuilder.append("; ");
            }
            first = false;
            cookieBuilder.append(c.getKey()).append("=").append(c.getValue().getKey());
        }
        return cookieBuilder.toString();
    }

    private boolean isUnexpired(Map.Entry<String, Date> values) {
        Date expires = values.getValue();
        return expires == null || new Date().compareTo(expires) == 1;
    }

    public void clear() {
        this.cookies.clear();
    }

    public String cookieHeader() {
        return this.cookieMapToHeaderString(this.cookies);
    }
}

