/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class AssessmentResultResult {

    /**
     * The result of the test.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends AssessmentResultValue> value;

    /**
     * The source value of the test result.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends AssessmentResultSourceValue> sourceValue;

    @JsonCreator
    public AssessmentResultResult(
            @JsonProperty("value") JsonNullable<? extends AssessmentResultValue> value,
            @JsonProperty("source_value") JsonNullable<? extends AssessmentResultSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public AssessmentResultResult() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The result of the test.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AssessmentResultValue> value() {
        return (JsonNullable<AssessmentResultValue>) value;
    }

    /**
     * The source value of the test result.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AssessmentResultSourceValue> sourceValue() {
        return (JsonNullable<AssessmentResultSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The result of the test.
     */
    public AssessmentResultResult withValue(AssessmentResultValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The result of the test.
     */
    public AssessmentResultResult withValue(JsonNullable<? extends AssessmentResultValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the test result.
     */
    public AssessmentResultResult withSourceValue(AssessmentResultSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the test result.
     */
    public AssessmentResultResult withSourceValue(JsonNullable<? extends AssessmentResultSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AssessmentResultResult other = (AssessmentResultResult) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AssessmentResultResult.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends AssessmentResultValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends AssessmentResultSourceValue> sourceValue = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The result of the test.
         */
        public Builder value(AssessmentResultValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The result of the test.
         */
        public Builder value(JsonNullable<? extends AssessmentResultValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the test result.
         */
        public Builder sourceValue(AssessmentResultSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the test result.
         */
        public Builder sourceValue(JsonNullable<? extends AssessmentResultSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public AssessmentResultResult build() {
            return new AssessmentResultResult(
                value,
                sourceValue);
        }
    }
}

