/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Question {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends QuestionType> type;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("text")
    private JsonNullable<String> text;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("required")
    private JsonNullable<? extends QuestionRequired> required;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("multiple_choice_answers")
    private JsonNullable<? extends List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("parent_question")
    private JsonNullable<? extends ParentQuestion> parentQuestion;

    @JsonCreator
    public Question(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("type") JsonNullable<? extends QuestionType> type,
            @JsonProperty("text") JsonNullable<String> text,
            @JsonProperty("required") JsonNullable<? extends QuestionRequired> required,
            @JsonProperty("multiple_choice_answers") JsonNullable<? extends List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers,
            @JsonProperty("parent_question") JsonNullable<? extends ParentQuestion> parentQuestion) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(text, "text");
        Utils.checkNotNull(required, "required");
        Utils.checkNotNull(multipleChoiceAnswers, "multipleChoiceAnswers");
        Utils.checkNotNull(parentQuestion, "parentQuestion");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.type = type;
        this.text = text;
        this.required = required;
        this.multipleChoiceAnswers = multipleChoiceAnswers;
        this.parentQuestion = parentQuestion;
    }
    
    public Question() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<QuestionType> type() {
        return (JsonNullable<QuestionType>) type;
    }

    @JsonIgnore
    public JsonNullable<String> text() {
        return text;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<QuestionRequired> required() {
        return (JsonNullable<QuestionRequired>) required;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers() {
        return (JsonNullable<List<QuestionMultipleChoiceAnswers>>) multipleChoiceAnswers;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ParentQuestion> parentQuestion() {
        return (JsonNullable<ParentQuestion>) parentQuestion;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public Question withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Question withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Question withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Question withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public Question withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    public Question withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public Question withType(QuestionType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    public Question withType(JsonNullable<? extends QuestionType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public Question withText(String text) {
        Utils.checkNotNull(text, "text");
        this.text = JsonNullable.of(text);
        return this;
    }

    public Question withText(JsonNullable<String> text) {
        Utils.checkNotNull(text, "text");
        this.text = text;
        return this;
    }

    public Question withRequired(QuestionRequired required) {
        Utils.checkNotNull(required, "required");
        this.required = JsonNullable.of(required);
        return this;
    }

    public Question withRequired(JsonNullable<? extends QuestionRequired> required) {
        Utils.checkNotNull(required, "required");
        this.required = required;
        return this;
    }

    public Question withMultipleChoiceAnswers(List<QuestionMultipleChoiceAnswers> multipleChoiceAnswers) {
        Utils.checkNotNull(multipleChoiceAnswers, "multipleChoiceAnswers");
        this.multipleChoiceAnswers = JsonNullable.of(multipleChoiceAnswers);
        return this;
    }

    public Question withMultipleChoiceAnswers(JsonNullable<? extends List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers) {
        Utils.checkNotNull(multipleChoiceAnswers, "multipleChoiceAnswers");
        this.multipleChoiceAnswers = multipleChoiceAnswers;
        return this;
    }

    public Question withParentQuestion(ParentQuestion parentQuestion) {
        Utils.checkNotNull(parentQuestion, "parentQuestion");
        this.parentQuestion = JsonNullable.of(parentQuestion);
        return this;
    }

    public Question withParentQuestion(JsonNullable<? extends ParentQuestion> parentQuestion) {
        Utils.checkNotNull(parentQuestion, "parentQuestion");
        this.parentQuestion = parentQuestion;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Question other = (Question) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.type, other.type) &&
            Objects.deepEquals(this.text, other.text) &&
            Objects.deepEquals(this.required, other.required) &&
            Objects.deepEquals(this.multipleChoiceAnswers, other.multipleChoiceAnswers) &&
            Objects.deepEquals(this.parentQuestion, other.parentQuestion);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            name,
            type,
            text,
            required,
            multipleChoiceAnswers,
            parentQuestion);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Question.class,
                "id", id,
                "remoteId", remoteId,
                "name", name,
                "type", type,
                "text", text,
                "required", required,
                "multipleChoiceAnswers", multipleChoiceAnswers,
                "parentQuestion", parentQuestion);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<? extends QuestionType> type = JsonNullable.undefined();
 
        private JsonNullable<String> text = JsonNullable.undefined();
 
        private JsonNullable<? extends QuestionRequired> required = JsonNullable.undefined();
 
        private JsonNullable<? extends List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers = JsonNullable.undefined();
 
        private JsonNullable<? extends ParentQuestion> parentQuestion = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder type(QuestionType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        public Builder type(JsonNullable<? extends QuestionType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public Builder text(String text) {
            Utils.checkNotNull(text, "text");
            this.text = JsonNullable.of(text);
            return this;
        }

        public Builder text(JsonNullable<String> text) {
            Utils.checkNotNull(text, "text");
            this.text = text;
            return this;
        }

        public Builder required(QuestionRequired required) {
            Utils.checkNotNull(required, "required");
            this.required = JsonNullable.of(required);
            return this;
        }

        public Builder required(JsonNullable<? extends QuestionRequired> required) {
            Utils.checkNotNull(required, "required");
            this.required = required;
            return this;
        }

        public Builder multipleChoiceAnswers(List<QuestionMultipleChoiceAnswers> multipleChoiceAnswers) {
            Utils.checkNotNull(multipleChoiceAnswers, "multipleChoiceAnswers");
            this.multipleChoiceAnswers = JsonNullable.of(multipleChoiceAnswers);
            return this;
        }

        public Builder multipleChoiceAnswers(JsonNullable<? extends List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers) {
            Utils.checkNotNull(multipleChoiceAnswers, "multipleChoiceAnswers");
            this.multipleChoiceAnswers = multipleChoiceAnswers;
            return this;
        }

        public Builder parentQuestion(ParentQuestion parentQuestion) {
            Utils.checkNotNull(parentQuestion, "parentQuestion");
            this.parentQuestion = JsonNullable.of(parentQuestion);
            return this;
        }

        public Builder parentQuestion(JsonNullable<? extends ParentQuestion> parentQuestion) {
            Utils.checkNotNull(parentQuestion, "parentQuestion");
            this.parentQuestion = parentQuestion;
            return this;
        }
        
        public Question build() {
            return new Question(
                id,
                remoteId,
                name,
                type,
                text,
                required,
                multipleChoiceAnswers,
                parentQuestion);
        }
    }
}

