/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.JobPostingContentSection;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class JobPostingContent {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="plain")
    private JsonNullable<String> plain;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="html")
    private JsonNullable<String> html;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="sections")
    private JsonNullable<? extends List<JobPostingContentSection>> sections;

    @JsonCreator
    public JobPostingContent(@JsonProperty(value="plain") JsonNullable<String> plain, @JsonProperty(value="html") JsonNullable<String> html, @JsonProperty(value="sections") JsonNullable<? extends List<JobPostingContentSection>> sections) {
        Utils.checkNotNull(plain, "plain");
        Utils.checkNotNull(html, "html");
        Utils.checkNotNull(sections, "sections");
        this.plain = plain;
        this.html = html;
        this.sections = sections;
    }

    public JobPostingContent() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends List<JobPostingContentSection>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> plain() {
        return this.plain;
    }

    @JsonIgnore
    public JsonNullable<String> html() {
        return this.html;
    }

    @JsonIgnore
    public JsonNullable<List<JobPostingContentSection>> sections() {
        return this.sections;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public JobPostingContent withPlain(String plain) {
        Utils.checkNotNull(plain, "plain");
        this.plain = JsonNullable.of((Object)plain);
        return this;
    }

    public JobPostingContent withPlain(JsonNullable<String> plain) {
        Utils.checkNotNull(plain, "plain");
        this.plain = plain;
        return this;
    }

    public JobPostingContent withHtml(String html) {
        Utils.checkNotNull(html, "html");
        this.html = JsonNullable.of((Object)html);
        return this;
    }

    public JobPostingContent withHtml(JsonNullable<String> html) {
        Utils.checkNotNull(html, "html");
        this.html = html;
        return this;
    }

    public JobPostingContent withSections(List<JobPostingContentSection> sections) {
        Utils.checkNotNull(sections, "sections");
        this.sections = JsonNullable.of(sections);
        return this;
    }

    public JobPostingContent withSections(JsonNullable<? extends List<JobPostingContentSection>> sections) {
        Utils.checkNotNull(sections, "sections");
        this.sections = sections;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobPostingContent other = (JobPostingContent)o;
        return Objects.deepEquals(this.plain, other.plain) && Objects.deepEquals(this.html, other.html) && Objects.deepEquals(this.sections, other.sections);
    }

    public int hashCode() {
        return Objects.hash(this.plain, this.html, this.sections);
    }

    public String toString() {
        return Utils.toString(JobPostingContent.class, "plain", this.plain, "html", this.html, "sections", this.sections);
    }

    public static final class Builder {
        private JsonNullable<String> plain = JsonNullable.undefined();
        private JsonNullable<String> html = JsonNullable.undefined();
        private JsonNullable<? extends List<JobPostingContentSection>> sections = JsonNullable.undefined();

        private Builder() {
        }

        public Builder plain(String plain) {
            Utils.checkNotNull(plain, "plain");
            this.plain = JsonNullable.of((Object)plain);
            return this;
        }

        public Builder plain(JsonNullable<String> plain) {
            Utils.checkNotNull(plain, "plain");
            this.plain = plain;
            return this;
        }

        public Builder html(String html) {
            Utils.checkNotNull(html, "html");
            this.html = JsonNullable.of((Object)html);
            return this;
        }

        public Builder html(JsonNullable<String> html) {
            Utils.checkNotNull(html, "html");
            this.html = html;
            return this;
        }

        public Builder sections(List<JobPostingContentSection> sections) {
            Utils.checkNotNull(sections, "sections");
            this.sections = JsonNullable.of(sections);
            return this;
        }

        public Builder sections(JsonNullable<? extends List<JobPostingContentSection>> sections) {
            Utils.checkNotNull(sections, "sections");
            this.sections = sections;
            return this;
        }

        public JobPostingContent build() {
            return new JobPostingContent(this.plain, this.html, this.sections);
        }
    }
}

