/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.operations.LmsListCoursesRequest;
import com.stackone.stackone_client_java.models.operations.LmsListCoursesResponse;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.stream.Stream;

public class LmsListCoursesRequestBuilder {
    private LmsListCoursesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallLmsListCourses sdk;

    public LmsListCoursesRequestBuilder(SDKMethodInterfaces.MethodCallLmsListCourses sdk) {
        this.sdk = sdk;
    }

    public LmsListCoursesRequestBuilder request(LmsListCoursesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public LmsListCoursesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsListCoursesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public LmsListCoursesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.listCourses(this.request, options);
    }

    public Stream<LmsListCoursesResponse> callAsStream() {
        return Utils.stream(() -> Optional.of(this.call()), x -> {
            if (x.statusCode() >= 300) {
                byte[] body = Utils.toByteArrayAndClose(x.rawResponse().body());
                throw new SDKError(x.rawResponse(), x.statusCode(), x.contentType(), body);
            }
            return x.next();
        });
    }
}

