/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class TimeOff {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The employee ID
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employee_id")
    private JsonNullable<String> employeeId;

    /**
     * Provider's unique identifier of the employee
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_employee_id")
    private JsonNullable<String> remoteEmployeeId;

    /**
     * The approver ID
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("approver_id")
    private JsonNullable<String> approverId;

    /**
     * Provider's unique identifier of the approver
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_approver_id")
    private JsonNullable<String> remoteApproverId;

    /**
     * The status of the time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends TimeOffStatus> status;

    /**
     * The type of the time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends TimeOffType> type;

    /**
     * The start date of the time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_date")
    private JsonNullable<OffsetDateTime> startDate;

    /**
     * The end date of the time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_date")
    private JsonNullable<OffsetDateTime> endDate;

    /**
     * True if the start of the time off request begins half way through the day
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_half_day")
    private JsonNullable<? extends StartHalfDay> startHalfDay;

    /**
     * True if the end of the time off request ends half way through the day
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_half_day")
    private JsonNullable<? extends EndHalfDay> endHalfDay;

    /**
     * The duration of the time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("duration")
    private JsonNullable<String> duration;

    /**
     * The time off policy id associated with this time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("time_off_policy_id")
    private JsonNullable<String> timeOffPolicyId;

    /**
     * Provider's unique identifier of the time off policy id associated with this time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_time_off_policy_id")
    private JsonNullable<String> remoteTimeOffPolicyId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("reason")
    private JsonNullable<? extends TimeOffReason> reason;

    /**
     * The created date of the time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_date")
    private JsonNullable<OffsetDateTime> createdDate;

    /**
     * The updated date of the time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_date")
    private JsonNullable<OffsetDateTime> updatedDate;

    @JsonCreator
    public TimeOff(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("employee_id") JsonNullable<String> employeeId,
            @JsonProperty("remote_employee_id") JsonNullable<String> remoteEmployeeId,
            @JsonProperty("approver_id") JsonNullable<String> approverId,
            @JsonProperty("remote_approver_id") JsonNullable<String> remoteApproverId,
            @JsonProperty("status") JsonNullable<? extends TimeOffStatus> status,
            @JsonProperty("type") JsonNullable<? extends TimeOffType> type,
            @JsonProperty("start_date") JsonNullable<OffsetDateTime> startDate,
            @JsonProperty("end_date") JsonNullable<OffsetDateTime> endDate,
            @JsonProperty("start_half_day") JsonNullable<? extends StartHalfDay> startHalfDay,
            @JsonProperty("end_half_day") JsonNullable<? extends EndHalfDay> endHalfDay,
            @JsonProperty("duration") JsonNullable<String> duration,
            @JsonProperty("time_off_policy_id") JsonNullable<String> timeOffPolicyId,
            @JsonProperty("remote_time_off_policy_id") JsonNullable<String> remoteTimeOffPolicyId,
            @JsonProperty("reason") JsonNullable<? extends TimeOffReason> reason,
            @JsonProperty("created_date") JsonNullable<OffsetDateTime> createdDate,
            @JsonProperty("updated_date") JsonNullable<OffsetDateTime> updatedDate) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(employeeId, "employeeId");
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        Utils.checkNotNull(approverId, "approverId");
        Utils.checkNotNull(remoteApproverId, "remoteApproverId");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(startDate, "startDate");
        Utils.checkNotNull(endDate, "endDate");
        Utils.checkNotNull(startHalfDay, "startHalfDay");
        Utils.checkNotNull(endHalfDay, "endHalfDay");
        Utils.checkNotNull(duration, "duration");
        Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
        Utils.checkNotNull(remoteTimeOffPolicyId, "remoteTimeOffPolicyId");
        Utils.checkNotNull(reason, "reason");
        Utils.checkNotNull(createdDate, "createdDate");
        Utils.checkNotNull(updatedDate, "updatedDate");
        this.id = id;
        this.remoteId = remoteId;
        this.employeeId = employeeId;
        this.remoteEmployeeId = remoteEmployeeId;
        this.approverId = approverId;
        this.remoteApproverId = remoteApproverId;
        this.status = status;
        this.type = type;
        this.startDate = startDate;
        this.endDate = endDate;
        this.startHalfDay = startHalfDay;
        this.endHalfDay = endHalfDay;
        this.duration = duration;
        this.timeOffPolicyId = timeOffPolicyId;
        this.remoteTimeOffPolicyId = remoteTimeOffPolicyId;
        this.reason = reason;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
    }
    
    public TimeOff() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The employee ID
     */
    @JsonIgnore
    public JsonNullable<String> employeeId() {
        return employeeId;
    }

    /**
     * Provider's unique identifier of the employee
     */
    @JsonIgnore
    public JsonNullable<String> remoteEmployeeId() {
        return remoteEmployeeId;
    }

    /**
     * The approver ID
     */
    @JsonIgnore
    public JsonNullable<String> approverId() {
        return approverId;
    }

    /**
     * Provider's unique identifier of the approver
     */
    @JsonIgnore
    public JsonNullable<String> remoteApproverId() {
        return remoteApproverId;
    }

    /**
     * The status of the time off request
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TimeOffStatus> status() {
        return (JsonNullable<TimeOffStatus>) status;
    }

    /**
     * The type of the time off request
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TimeOffType> type() {
        return (JsonNullable<TimeOffType>) type;
    }

    /**
     * The start date of the time off request
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startDate() {
        return startDate;
    }

    /**
     * The end date of the time off request
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> endDate() {
        return endDate;
    }

    /**
     * True if the start of the time off request begins half way through the day
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<StartHalfDay> startHalfDay() {
        return (JsonNullable<StartHalfDay>) startHalfDay;
    }

    /**
     * True if the end of the time off request ends half way through the day
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EndHalfDay> endHalfDay() {
        return (JsonNullable<EndHalfDay>) endHalfDay;
    }

    /**
     * The duration of the time off request
     */
    @JsonIgnore
    public JsonNullable<String> duration() {
        return duration;
    }

    /**
     * The time off policy id associated with this time off request
     */
    @JsonIgnore
    public JsonNullable<String> timeOffPolicyId() {
        return timeOffPolicyId;
    }

    /**
     * Provider's unique identifier of the time off policy id associated with this time off request
     */
    @JsonIgnore
    public JsonNullable<String> remoteTimeOffPolicyId() {
        return remoteTimeOffPolicyId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TimeOffReason> reason() {
        return (JsonNullable<TimeOffReason>) reason;
    }

    /**
     * The created date of the time off request
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdDate() {
        return createdDate;
    }

    /**
     * The updated date of the time off request
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedDate() {
        return updatedDate;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public TimeOff withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public TimeOff withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TimeOff withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TimeOff withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The employee ID
     */
    public TimeOff withEmployeeId(String employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = JsonNullable.of(employeeId);
        return this;
    }

    /**
     * The employee ID
     */
    public TimeOff withEmployeeId(JsonNullable<String> employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = employeeId;
        return this;
    }

    /**
     * Provider's unique identifier of the employee
     */
    public TimeOff withRemoteEmployeeId(String remoteEmployeeId) {
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        this.remoteEmployeeId = JsonNullable.of(remoteEmployeeId);
        return this;
    }

    /**
     * Provider's unique identifier of the employee
     */
    public TimeOff withRemoteEmployeeId(JsonNullable<String> remoteEmployeeId) {
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        this.remoteEmployeeId = remoteEmployeeId;
        return this;
    }

    /**
     * The approver ID
     */
    public TimeOff withApproverId(String approverId) {
        Utils.checkNotNull(approverId, "approverId");
        this.approverId = JsonNullable.of(approverId);
        return this;
    }

    /**
     * The approver ID
     */
    public TimeOff withApproverId(JsonNullable<String> approverId) {
        Utils.checkNotNull(approverId, "approverId");
        this.approverId = approverId;
        return this;
    }

    /**
     * Provider's unique identifier of the approver
     */
    public TimeOff withRemoteApproverId(String remoteApproverId) {
        Utils.checkNotNull(remoteApproverId, "remoteApproverId");
        this.remoteApproverId = JsonNullable.of(remoteApproverId);
        return this;
    }

    /**
     * Provider's unique identifier of the approver
     */
    public TimeOff withRemoteApproverId(JsonNullable<String> remoteApproverId) {
        Utils.checkNotNull(remoteApproverId, "remoteApproverId");
        this.remoteApproverId = remoteApproverId;
        return this;
    }

    /**
     * The status of the time off request
     */
    public TimeOff withStatus(TimeOffStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * The status of the time off request
     */
    public TimeOff withStatus(JsonNullable<? extends TimeOffStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The type of the time off request
     */
    public TimeOff withType(TimeOffType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The type of the time off request
     */
    public TimeOff withType(JsonNullable<? extends TimeOffType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The start date of the time off request
     */
    public TimeOff withStartDate(OffsetDateTime startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = JsonNullable.of(startDate);
        return this;
    }

    /**
     * The start date of the time off request
     */
    public TimeOff withStartDate(JsonNullable<OffsetDateTime> startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = startDate;
        return this;
    }

    /**
     * The end date of the time off request
     */
    public TimeOff withEndDate(OffsetDateTime endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = JsonNullable.of(endDate);
        return this;
    }

    /**
     * The end date of the time off request
     */
    public TimeOff withEndDate(JsonNullable<OffsetDateTime> endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = endDate;
        return this;
    }

    /**
     * True if the start of the time off request begins half way through the day
     */
    public TimeOff withStartHalfDay(StartHalfDay startHalfDay) {
        Utils.checkNotNull(startHalfDay, "startHalfDay");
        this.startHalfDay = JsonNullable.of(startHalfDay);
        return this;
    }

    /**
     * True if the start of the time off request begins half way through the day
     */
    public TimeOff withStartHalfDay(JsonNullable<? extends StartHalfDay> startHalfDay) {
        Utils.checkNotNull(startHalfDay, "startHalfDay");
        this.startHalfDay = startHalfDay;
        return this;
    }

    /**
     * True if the end of the time off request ends half way through the day
     */
    public TimeOff withEndHalfDay(EndHalfDay endHalfDay) {
        Utils.checkNotNull(endHalfDay, "endHalfDay");
        this.endHalfDay = JsonNullable.of(endHalfDay);
        return this;
    }

    /**
     * True if the end of the time off request ends half way through the day
     */
    public TimeOff withEndHalfDay(JsonNullable<? extends EndHalfDay> endHalfDay) {
        Utils.checkNotNull(endHalfDay, "endHalfDay");
        this.endHalfDay = endHalfDay;
        return this;
    }

    /**
     * The duration of the time off request
     */
    public TimeOff withDuration(String duration) {
        Utils.checkNotNull(duration, "duration");
        this.duration = JsonNullable.of(duration);
        return this;
    }

    /**
     * The duration of the time off request
     */
    public TimeOff withDuration(JsonNullable<String> duration) {
        Utils.checkNotNull(duration, "duration");
        this.duration = duration;
        return this;
    }

    /**
     * The time off policy id associated with this time off request
     */
    public TimeOff withTimeOffPolicyId(String timeOffPolicyId) {
        Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
        this.timeOffPolicyId = JsonNullable.of(timeOffPolicyId);
        return this;
    }

    /**
     * The time off policy id associated with this time off request
     */
    public TimeOff withTimeOffPolicyId(JsonNullable<String> timeOffPolicyId) {
        Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
        this.timeOffPolicyId = timeOffPolicyId;
        return this;
    }

    /**
     * Provider's unique identifier of the time off policy id associated with this time off request
     */
    public TimeOff withRemoteTimeOffPolicyId(String remoteTimeOffPolicyId) {
        Utils.checkNotNull(remoteTimeOffPolicyId, "remoteTimeOffPolicyId");
        this.remoteTimeOffPolicyId = JsonNullable.of(remoteTimeOffPolicyId);
        return this;
    }

    /**
     * Provider's unique identifier of the time off policy id associated with this time off request
     */
    public TimeOff withRemoteTimeOffPolicyId(JsonNullable<String> remoteTimeOffPolicyId) {
        Utils.checkNotNull(remoteTimeOffPolicyId, "remoteTimeOffPolicyId");
        this.remoteTimeOffPolicyId = remoteTimeOffPolicyId;
        return this;
    }

    public TimeOff withReason(TimeOffReason reason) {
        Utils.checkNotNull(reason, "reason");
        this.reason = JsonNullable.of(reason);
        return this;
    }

    public TimeOff withReason(JsonNullable<? extends TimeOffReason> reason) {
        Utils.checkNotNull(reason, "reason");
        this.reason = reason;
        return this;
    }

    /**
     * The created date of the time off request
     */
    public TimeOff withCreatedDate(OffsetDateTime createdDate) {
        Utils.checkNotNull(createdDate, "createdDate");
        this.createdDate = JsonNullable.of(createdDate);
        return this;
    }

    /**
     * The created date of the time off request
     */
    public TimeOff withCreatedDate(JsonNullable<OffsetDateTime> createdDate) {
        Utils.checkNotNull(createdDate, "createdDate");
        this.createdDate = createdDate;
        return this;
    }

    /**
     * The updated date of the time off request
     */
    public TimeOff withUpdatedDate(OffsetDateTime updatedDate) {
        Utils.checkNotNull(updatedDate, "updatedDate");
        this.updatedDate = JsonNullable.of(updatedDate);
        return this;
    }

    /**
     * The updated date of the time off request
     */
    public TimeOff withUpdatedDate(JsonNullable<OffsetDateTime> updatedDate) {
        Utils.checkNotNull(updatedDate, "updatedDate");
        this.updatedDate = updatedDate;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TimeOff other = (TimeOff) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.employeeId, other.employeeId) &&
            Objects.deepEquals(this.remoteEmployeeId, other.remoteEmployeeId) &&
            Objects.deepEquals(this.approverId, other.approverId) &&
            Objects.deepEquals(this.remoteApproverId, other.remoteApproverId) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.type, other.type) &&
            Objects.deepEquals(this.startDate, other.startDate) &&
            Objects.deepEquals(this.endDate, other.endDate) &&
            Objects.deepEquals(this.startHalfDay, other.startHalfDay) &&
            Objects.deepEquals(this.endHalfDay, other.endHalfDay) &&
            Objects.deepEquals(this.duration, other.duration) &&
            Objects.deepEquals(this.timeOffPolicyId, other.timeOffPolicyId) &&
            Objects.deepEquals(this.remoteTimeOffPolicyId, other.remoteTimeOffPolicyId) &&
            Objects.deepEquals(this.reason, other.reason) &&
            Objects.deepEquals(this.createdDate, other.createdDate) &&
            Objects.deepEquals(this.updatedDate, other.updatedDate);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            employeeId,
            remoteEmployeeId,
            approverId,
            remoteApproverId,
            status,
            type,
            startDate,
            endDate,
            startHalfDay,
            endHalfDay,
            duration,
            timeOffPolicyId,
            remoteTimeOffPolicyId,
            reason,
            createdDate,
            updatedDate);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TimeOff.class,
                "id", id,
                "remoteId", remoteId,
                "employeeId", employeeId,
                "remoteEmployeeId", remoteEmployeeId,
                "approverId", approverId,
                "remoteApproverId", remoteApproverId,
                "status", status,
                "type", type,
                "startDate", startDate,
                "endDate", endDate,
                "startHalfDay", startHalfDay,
                "endHalfDay", endHalfDay,
                "duration", duration,
                "timeOffPolicyId", timeOffPolicyId,
                "remoteTimeOffPolicyId", remoteTimeOffPolicyId,
                "reason", reason,
                "createdDate", createdDate,
                "updatedDate", updatedDate);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<String> employeeId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteEmployeeId = JsonNullable.undefined();
 
        private JsonNullable<String> approverId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteApproverId = JsonNullable.undefined();
 
        private JsonNullable<? extends TimeOffStatus> status = JsonNullable.undefined();
 
        private JsonNullable<? extends TimeOffType> type = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> startDate = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> endDate = JsonNullable.undefined();
 
        private JsonNullable<? extends StartHalfDay> startHalfDay = JsonNullable.undefined();
 
        private JsonNullable<? extends EndHalfDay> endHalfDay = JsonNullable.undefined();
 
        private JsonNullable<String> duration = JsonNullable.undefined();
 
        private JsonNullable<String> timeOffPolicyId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteTimeOffPolicyId = JsonNullable.undefined();
 
        private JsonNullable<? extends TimeOffReason> reason = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdDate = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedDate = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * The employee ID
         */
        public Builder employeeId(String employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = JsonNullable.of(employeeId);
            return this;
        }

        /**
         * The employee ID
         */
        public Builder employeeId(JsonNullable<String> employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = employeeId;
            return this;
        }

        /**
         * Provider's unique identifier of the employee
         */
        public Builder remoteEmployeeId(String remoteEmployeeId) {
            Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
            this.remoteEmployeeId = JsonNullable.of(remoteEmployeeId);
            return this;
        }

        /**
         * Provider's unique identifier of the employee
         */
        public Builder remoteEmployeeId(JsonNullable<String> remoteEmployeeId) {
            Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
            this.remoteEmployeeId = remoteEmployeeId;
            return this;
        }

        /**
         * The approver ID
         */
        public Builder approverId(String approverId) {
            Utils.checkNotNull(approverId, "approverId");
            this.approverId = JsonNullable.of(approverId);
            return this;
        }

        /**
         * The approver ID
         */
        public Builder approverId(JsonNullable<String> approverId) {
            Utils.checkNotNull(approverId, "approverId");
            this.approverId = approverId;
            return this;
        }

        /**
         * Provider's unique identifier of the approver
         */
        public Builder remoteApproverId(String remoteApproverId) {
            Utils.checkNotNull(remoteApproverId, "remoteApproverId");
            this.remoteApproverId = JsonNullable.of(remoteApproverId);
            return this;
        }

        /**
         * Provider's unique identifier of the approver
         */
        public Builder remoteApproverId(JsonNullable<String> remoteApproverId) {
            Utils.checkNotNull(remoteApproverId, "remoteApproverId");
            this.remoteApproverId = remoteApproverId;
            return this;
        }

        /**
         * The status of the time off request
         */
        public Builder status(TimeOffStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * The status of the time off request
         */
        public Builder status(JsonNullable<? extends TimeOffStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * The type of the time off request
         */
        public Builder type(TimeOffType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The type of the time off request
         */
        public Builder type(JsonNullable<? extends TimeOffType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        /**
         * The start date of the time off request
         */
        public Builder startDate(OffsetDateTime startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = JsonNullable.of(startDate);
            return this;
        }

        /**
         * The start date of the time off request
         */
        public Builder startDate(JsonNullable<OffsetDateTime> startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = startDate;
            return this;
        }

        /**
         * The end date of the time off request
         */
        public Builder endDate(OffsetDateTime endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = JsonNullable.of(endDate);
            return this;
        }

        /**
         * The end date of the time off request
         */
        public Builder endDate(JsonNullable<OffsetDateTime> endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = endDate;
            return this;
        }

        /**
         * True if the start of the time off request begins half way through the day
         */
        public Builder startHalfDay(StartHalfDay startHalfDay) {
            Utils.checkNotNull(startHalfDay, "startHalfDay");
            this.startHalfDay = JsonNullable.of(startHalfDay);
            return this;
        }

        /**
         * True if the start of the time off request begins half way through the day
         */
        public Builder startHalfDay(JsonNullable<? extends StartHalfDay> startHalfDay) {
            Utils.checkNotNull(startHalfDay, "startHalfDay");
            this.startHalfDay = startHalfDay;
            return this;
        }

        /**
         * True if the end of the time off request ends half way through the day
         */
        public Builder endHalfDay(EndHalfDay endHalfDay) {
            Utils.checkNotNull(endHalfDay, "endHalfDay");
            this.endHalfDay = JsonNullable.of(endHalfDay);
            return this;
        }

        /**
         * True if the end of the time off request ends half way through the day
         */
        public Builder endHalfDay(JsonNullable<? extends EndHalfDay> endHalfDay) {
            Utils.checkNotNull(endHalfDay, "endHalfDay");
            this.endHalfDay = endHalfDay;
            return this;
        }

        /**
         * The duration of the time off request
         */
        public Builder duration(String duration) {
            Utils.checkNotNull(duration, "duration");
            this.duration = JsonNullable.of(duration);
            return this;
        }

        /**
         * The duration of the time off request
         */
        public Builder duration(JsonNullable<String> duration) {
            Utils.checkNotNull(duration, "duration");
            this.duration = duration;
            return this;
        }

        /**
         * The time off policy id associated with this time off request
         */
        public Builder timeOffPolicyId(String timeOffPolicyId) {
            Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
            this.timeOffPolicyId = JsonNullable.of(timeOffPolicyId);
            return this;
        }

        /**
         * The time off policy id associated with this time off request
         */
        public Builder timeOffPolicyId(JsonNullable<String> timeOffPolicyId) {
            Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
            this.timeOffPolicyId = timeOffPolicyId;
            return this;
        }

        /**
         * Provider's unique identifier of the time off policy id associated with this time off request
         */
        public Builder remoteTimeOffPolicyId(String remoteTimeOffPolicyId) {
            Utils.checkNotNull(remoteTimeOffPolicyId, "remoteTimeOffPolicyId");
            this.remoteTimeOffPolicyId = JsonNullable.of(remoteTimeOffPolicyId);
            return this;
        }

        /**
         * Provider's unique identifier of the time off policy id associated with this time off request
         */
        public Builder remoteTimeOffPolicyId(JsonNullable<String> remoteTimeOffPolicyId) {
            Utils.checkNotNull(remoteTimeOffPolicyId, "remoteTimeOffPolicyId");
            this.remoteTimeOffPolicyId = remoteTimeOffPolicyId;
            return this;
        }

        public Builder reason(TimeOffReason reason) {
            Utils.checkNotNull(reason, "reason");
            this.reason = JsonNullable.of(reason);
            return this;
        }

        public Builder reason(JsonNullable<? extends TimeOffReason> reason) {
            Utils.checkNotNull(reason, "reason");
            this.reason = reason;
            return this;
        }

        /**
         * The created date of the time off request
         */
        public Builder createdDate(OffsetDateTime createdDate) {
            Utils.checkNotNull(createdDate, "createdDate");
            this.createdDate = JsonNullable.of(createdDate);
            return this;
        }

        /**
         * The created date of the time off request
         */
        public Builder createdDate(JsonNullable<OffsetDateTime> createdDate) {
            Utils.checkNotNull(createdDate, "createdDate");
            this.createdDate = createdDate;
            return this;
        }

        /**
         * The updated date of the time off request
         */
        public Builder updatedDate(OffsetDateTime updatedDate) {
            Utils.checkNotNull(updatedDate, "updatedDate");
            this.updatedDate = JsonNullable.of(updatedDate);
            return this;
        }

        /**
         * The updated date of the time off request
         */
        public Builder updatedDate(JsonNullable<OffsetDateTime> updatedDate) {
            Utils.checkNotNull(updatedDate, "updatedDate");
            this.updatedDate = updatedDate;
            return this;
        }
        
        public TimeOff build() {
            return new TimeOff(
                id,
                remoteId,
                employeeId,
                remoteEmployeeId,
                approverId,
                remoteApproverId,
                status,
                type,
                startDate,
                endDate,
                startHalfDay,
                endHalfDay,
                duration,
                timeOffPolicyId,
                remoteTimeOffPolicyId,
                reason,
                createdDate,
                updatedDate);
        }
    }
}

