/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.HrisListTimeEntriesRequest;
import com.stackone.stackone_client_java.models.operations.HrisListTimeEntriesResponse;
import com.stackone.stackone_client_java.operations.HrisListTimeEntries;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListTimeEntriesRequestBuilder {
    private HrisListTimeEntriesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public HrisListTimeEntriesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisListTimeEntriesRequestBuilder request(HrisListTimeEntriesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListTimeEntriesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListTimeEntriesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListTimeEntriesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListTimeEntries.Sync operation = new HrisListTimeEntries.Sync(this.sdkConfiguration, options);
        return (HrisListTimeEntriesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<HrisListTimeEntriesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListTimeEntries.Sync operation = new HrisListTimeEntries.Sync(this.sdkConfiguration, options);
        Paginator<HrisListTimeEntriesRequest, String> iterator = new Paginator<HrisListTimeEntriesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), HrisListTimeEntriesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<HrisListTimeEntriesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

