/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class TaskResultDataValue {
    public static final TaskResultDataValue OPEN = new TaskResultDataValue("open");
    public static final TaskResultDataValue IN_PROGRESS = new TaskResultDataValue("in_progress");
    public static final TaskResultDataValue BLOCKED = new TaskResultDataValue("blocked");
    public static final TaskResultDataValue COMPLETED = new TaskResultDataValue("completed");
    public static final TaskResultDataValue CANCELLED = new TaskResultDataValue("cancelled");
    public static final TaskResultDataValue UNMAPPED_VALUE = new TaskResultDataValue("unmapped_value");
    private static final Map<String, TaskResultDataValue> values = TaskResultDataValue.createValuesMap();
    private static final Map<String, TaskResultDataValueEnum> enums = TaskResultDataValue.createEnumsMap();
    private final String value;

    private TaskResultDataValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskResultDataValue of(String value) {
        Class<TaskResultDataValue> clazz = TaskResultDataValue.class;
        synchronized (TaskResultDataValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TaskResultDataValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<TaskResultDataValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskResultDataValue other = (TaskResultDataValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TaskResultDataValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskResultDataValue[] values() {
        Class<TaskResultDataValue> clazz = TaskResultDataValue.class;
        synchronized (TaskResultDataValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TaskResultDataValue[0]);
        }
    }

    private static final Map<String, TaskResultDataValue> createValuesMap() {
        LinkedHashMap<String, TaskResultDataValue> map = new LinkedHashMap<String, TaskResultDataValue>();
        map.put("open", OPEN);
        map.put("in_progress", IN_PROGRESS);
        map.put("blocked", BLOCKED);
        map.put("completed", COMPLETED);
        map.put("cancelled", CANCELLED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TaskResultDataValueEnum> createEnumsMap() {
        HashMap<String, TaskResultDataValueEnum> map = new HashMap<String, TaskResultDataValueEnum>();
        map.put("open", TaskResultDataValueEnum.OPEN);
        map.put("in_progress", TaskResultDataValueEnum.IN_PROGRESS);
        map.put("blocked", TaskResultDataValueEnum.BLOCKED);
        map.put("completed", TaskResultDataValueEnum.COMPLETED);
        map.put("cancelled", TaskResultDataValueEnum.CANCELLED);
        map.put("unmapped_value", TaskResultDataValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TaskResultDataValueEnum {
        OPEN("open"),
        IN_PROGRESS("in_progress"),
        BLOCKED("blocked"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TaskResultDataValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<TaskResultDataValue> {
        protected _Deserializer() {
            super(TaskResultDataValue.class);
        }

        public TaskResultDataValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return TaskResultDataValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<TaskResultDataValue> {
        protected _Serializer() {
            super(TaskResultDataValue.class);
        }

        public void serialize(TaskResultDataValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

