/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.EmploymentsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListEmploymentsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends EmploymentsPaginated> employmentsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListEmploymentsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends EmploymentsPaginated> employmentsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(employmentsPaginated, "employmentsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.employmentsPaginated = employmentsPaginated;
        this.headers = headers;
    }

    public HrisListEmploymentsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<EmploymentsPaginated> employmentsPaginated() {
        return this.employmentsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListEmploymentsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListEmploymentsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListEmploymentsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListEmploymentsResponse withEmploymentsPaginated(EmploymentsPaginated employmentsPaginated) {
        Utils.checkNotNull(employmentsPaginated, "employmentsPaginated");
        this.employmentsPaginated = Optional.ofNullable(employmentsPaginated);
        return this;
    }

    public HrisListEmploymentsResponse withEmploymentsPaginated(Optional<? extends EmploymentsPaginated> employmentsPaginated) {
        Utils.checkNotNull(employmentsPaginated, "employmentsPaginated");
        this.employmentsPaginated = employmentsPaginated;
        return this;
    }

    public HrisListEmploymentsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListEmploymentsResponse other = (HrisListEmploymentsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.employmentsPaginated, other.employmentsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.employmentsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListEmploymentsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "employmentsPaginated", this.employmentsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends EmploymentsPaginated> employmentsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder employmentsPaginated(EmploymentsPaginated employmentsPaginated) {
            Utils.checkNotNull(employmentsPaginated, "employmentsPaginated");
            this.employmentsPaginated = Optional.ofNullable(employmentsPaginated);
            return this;
        }

        public Builder employmentsPaginated(Optional<? extends EmploymentsPaginated> employmentsPaginated) {
            Utils.checkNotNull(employmentsPaginated, "employmentsPaginated");
            this.employmentsPaginated = employmentsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListEmploymentsResponse build() {
            return new HrisListEmploymentsResponse(this.contentType, this.statusCode, this.rawResponse, this.employmentsPaginated, this.headers);
        }
    }
}

